from whatap.value.value import Value
from whatap.value.value_enum import ValueEnum

from whatap.util.compare_util import CompareUtil


class IntArray(Value):
    def __init__(self, value=None):
        super(IntArray, self).__init__()
        if isinstance(value, list):
            self.value = value
        else:
            self.value = []
        self._hash = 0

    def compareTo(self, object):
        if isinstance(object, IntArray):
            return CompareUtil.compareTo(self.value, object.value)
        return 1

    def equals(self, object):
        if isinstance(object, IntArray):
            return self.value == object.value
        return False

    def hashCode(self):
        if not self._hash:
            if not self.value:
                return 0

            result = 1
            for v in self.value:
                result = 31 * result + v
            self._hash = result
        return self._hash

    def write(self, dout):
        dout.writeIntArray(self.value)

    def read(self, din):
        self.value = din.readIntArray()
        return self

    def getValueType(self):
        return ValueEnum.ARRAY_INT
