import whatap.agent.conf.configure as config
from whatap.io.data_outputx import DataOutputX
import whatap.util.lib.pyaes as pyaes
from StringIO import StringIO
from itertools import cycle


def NewCypher(cypher_key , xor_key ):
    cph = Cypher(cypher_key, xor_key)

    return cph

class Cypher:
    def __init__(self, cypher_key, xor_key):
        self.block = int(config.GetConfig().CypherLevel) / 8
        self.cypher_key = cypher_key[:self.block]
        self.xor_key = bytearray(xor_key)
        self.xor_len = len(self.xor_key)
        self.cypher = pyaes.AESModeOfOperationECB(self.cypher_key)

    def Encrypt(self, data_):
        if self.block == 0 or data_ is None:
            return data_

        dataLen = len(data_)
        remainder = dataLen % self.block
        if remainder != 0:
            data_ += '\0' * (self.block - remainder)

        encrypted_blocks = [
            self.cypher.encrypt(data_[i:i+self.block])
            for i in range(0, len(data_), self.block)
        ]

        return ''.join(encrypted_blocks)

    def Decrypt(self, data_):
        if self.block == 0 or self.cypher is None:
            return data_
        decrypted_blocks = [
            self.cypher.decrypt(data_[i:i+self.block])
            for i in range(0, len(data_), self.block)
        ]
        return ''.join(decrypted_blocks)

    def padding(self, src ):
        if len(src) == self.block:
            return src

        dest = ''+ self.block
        if len(src) > self.block:
            dest= src[:self.block]
        else:
            dest=  src

        return dest

    def Hide(self, data_):
        if self.block == 0 or self.xor_key is None:
            return data_

        data_bytes = bytearray(data_)
        for i in range(len(data_bytes)):
            data_bytes[i] ^= self.xor_key[i % self.xor_len]

        return str(data_bytes)


def test():
    c = Cypher('0123456789123456', 0)
    encoded = c.Encrypt('hello world')

    o = StringIO()
    for c in encoded:
        o.write('%02x' % ord(c))
    print(encoded, o.getvalue())


if __name__ == '__main__':
    test()
