from whatap.pack.pack import Pack
from whatap.pack.pack_enum import PackEnum

class TextRec :
    def __init__(self, div = None, hash = None, text = None ):
        self.div= div
        self.hash= hash
        self.text= text

class TextPack(Pack):
    def __init__(self):
        self.records= []

    def getPackType(self):
	    return PackEnum.PACK_TEXT

    def write(self, dout ):
        super(TextPack, self).write(dout)
        dout.writeDecimal(len(self.records))
        for r in self.records:
            dout.writeByte(r.div)
            dout.writeInt(r.hash)
            dout.writeText(r.text)

    def read(self, din ):
        super(TextPack, self).read(din)
        size = din.readDecimal()
        for i in range(size):
            div = din.readByte()
            hash = din.readInt()
            text = din.readText()
            self.records.append(TextRec(div = div, hash = hash, text = text))

    def addTexts(self, texts =[]):
        self.records += texts
