from whatap.io.data_outputx import DataOutputX
from whatap.io.data_inputx import DataInputX
from whatap.pack.pack import Pack
from whatap.pack.pack_enum import PackEnum



class TCPPortPerf :
	def __init__(self):
		self.port = None
		self.isAlive= None
		self.ip = None
		
	def write(self, out):
		dout = DataOutputX()
		dout.writeInt(self.port)
		dout.writeBoolean(self.isAlive)
		dout.writeInt(self.ip)
		out.writeBlob(dout.toByteArray())

	def read(self, inx):
		din = DataInputX( inx.readBlob())

		self.port = din.readInt()
		self.isAlive= din.readBoolean()
		self.ip= din.readInt()


class SMTCPPortPerfPack(Pack):
    def __init__(self):
        Pack.__init__(self)
        self.tcpPortPerf = []

    def getPackType(self):
        return PackEnum.PACK_SM_PORT_PERF

    def write(self, dout ):
        super(SMTCPPortPerfPack, self).write(dout)
        dout.writeDecimal(len(self.tcpPortPerf))
        for p in self.tcpPortPerf:
            p.write(dout)

    def read(self, dinx):
        din= DataInputX(dinx.readBlob())
        super(SMTCPPortPerfPack, self).read(din)
      
        cnt = din.readDecimal()
        for i in range(cnt):
            p = TCPPortPerf()
            p.read(din)
            self.tcpPortPerf.append(p)