from whatap.pack.pack_enum import PackEnum
from whatap.pack.pack import Pack
from whatap.io.data_outputx import DataOutputX
from whatap.io.data_inputx import DataInputX
from whatap.value.null_value import NullValue
from whatap.value.value_enum import ValueEnum
from whatap.value.text_value import TextValue
from whatap.value.decimal_value import DecimalValue
import whatap.value.value as value

class ProcFilePerf:
    def __init__(self):
        self.filepath = None
        self.size = None

    def write(self, doutx):
        dout = DataOutputX()
        dout.writeInt(self.filepath)
        dout.writeLong(self.size)

        doutx.writeBlob(dout.toByteArray())

    def read(self, dinx):
        din = DataInputX(dinx.readBlob())
        self.filepath = din.readInt()
        self.size = din.readLong()

class ProcNetPerf:
    def __init__(self):
        self.ip = None
        self.port = None
        self.count = None

    def write(self, doutx):
        dout = DataOutputX()
        dout.writeInt(self.ip)
        dout.writeShort(self.port)
        dout.writeInt(self.count)

        doutx.writeBlob(dout.toByteArray())

    def read(self, dinx):
        din = DataInputX(dinx)
        self.ip = din.readInt()
        self.port = din.readShort()
        self.count = din.readInt()

class ProcPerf:
    def __init__(self):
        self.ppid = None
        self.pid = None
        self.cpu = None
        self.memoryBytes = None
        self.memoryPercent = None
        self.readBps = 0.0
        self.writeBps = 0.0
        self.cmd1 = None
        self.cmd2 = None
        self.readIops = 0.0
        self.writeIops = 0.0
        self.user = None
        self.state = None
        self.createTime = None
        self.group = 0
        self.net = []
        self.file = []
        self.memoryShared = 0

    def write(self, doutx):
        dout = DataOutputX()
        dout.writeInt(self.ppid)
        dout.writeInt(self.pid)
        dout.writeFloat(self.cpu)
        dout.writeDecimal(self.memoryBytes)
        dout.writeFloat(self.memoryPercent)
        dout.writeFloat(self.readBps)
        dout.writeFloat(self.writeBps)
        dout.writeInt(self.cmd1)
        dout.writeInt(self.cmd2)
        dout.writeFloat(self.readIops)
        dout.writeFloat(self.writeIops)
        dout.writeInt(self.user)
        dout.writeInt(self.state)
        dout.writeLong(self.createTime)
        dout.writeDecimal(self.group)
        dout.writeDecimal(len(self.net))
        for n in self.net:
            n.write(dout)
        dout.writeDecimal(len(self.file))
        for f in self.file:
            f.write(dout)
        dout.writeDecimal(self.memoryShared)
        doutx.writeBlob(dout.toByteArray())

    def read(self, dinx):
        din = DataInputX(dinx.readBlob())
        self.ppid = din.readInt()
        self.pid = din.readInt()
        self.cpu = din.readFloat()
        self.memoryBytes = din.readDecimal()
        self.memoryPercent = din.readFloat()
        self.readBps = din.readFloat()
        self.writeBps = din.readFloat()
        self.cmd1 = din.readInt()
        self.cmd2 = din.readInt()
        self.readIops = din.readFloat()
        self.writeIops = din.readFloat()
        self.user = din.readInt()
        self.state = din.readInt()
        self.createTime = din.readLong()
        self.group = din.readDecimal()
        netCount = din.readDecimal()
        for i in range(netCount):
            n = ProcNetPerf()
            n.read(din)
            self.net.append(n)
        fileCount = din.readDecimal()
        for i in range(fileCount):
            f = ProcFilePerf()
            f.read(din)
            self.file.append(f)
        self.memoryShared = din.readDecimal()

class SMProcPack(Pack):
    def __init__(self):
        Pack.__init__(self)
        self.os = None
        self.proc = []

    def getPackType(self):
        return PackEnum.PACK_SM_PROC_PERF

    def write(self, dout ):
        super(SMProcPack, self).write(dout)
        dout.writeShort(self.os)
        dout.writeDecimal(len(self.proc))
        for p in self.proc:
            p.write(dout)

    def read(self, dinx):
        din= DataInputX(dinx.readBlob())
        super(SMProcPack, self).read(din)
        self.os = din.readShort()
        cnt = din.readDecimal()
        for i in range(cnt):
            p = ProcPerf()
            p.read(din)
            self.proc.append(p)