from whatap.pack.pack_enum import PackEnum
from whatap.pack.pack import Pack
from whatap.io.data_outputx import DataOutputX

from whatap.io.data_inputx import DataInputX

class SMNetPerfPack(Pack):
    def __init__(self):
        Pack.__init__(self)
        self.os = None
        self.netPerf = []

    def getPackType(self):
        return PackEnum.PACK_SM_NET_PERF

    def write(self, dout):
        super(SMNetPerfPack, self).write(dout)
        dout.writeShort(self.os)
        dout.writeDecimal(len(self.netPerf))
        for n in self.netPerf:
            n.write(dout)

    def read(self, din):
        din = DataInputX(din.readBlob())
        super(SMNetPerfPack, self).read(din)
        self.os = din.readShort()
        nicCount = din.readDecimal()
        for i in range(nicCount):
            n = NetPerf()
            n.read(din)
            self.netPerf.append(d)

class NetPerf(Pack):
    def __init__(self):
        self.desc = None
        self.ip = None
        self.hwAddr = None
        self.trafficIn = None
        self.trafficOut = None
        self.packetIn = None
        self.packetOut = None
        self.errorIn = None
        self.errorOut =  None
        self.droppedOut = None
        self.droppedIn = None

    def write(self, doutx ):
        dout= DataOutputX()
        dout.writeInt(self.desc)
        dout.writeBlob(self.ip)
        dout.writeText(self.hwAddr)
        dout.writeDouble(self.trafficIn)
        dout.writeDouble(self.trafficOut)
        dout.writeDouble(self.packetIn)
        dout.writeDouble(self.packetOut)
        dout.writeDouble(self.errorIn)
        dout.writeDouble(self.errorOut)
        dout.writeDouble(self.droppedOut)
        dout.writeDouble(self.droppedIn)

        dout.writeInt(1)

        doutx.writeBlob(dout.toByteArray())

    def read(self, dinx):
        din= DataInputX(dinx.readBlob())
        self.desc= din.ReadInt()
        self.ip= din.ReadInt()
        self.hwAddr = din.ReadInt()
        self.trafficIn = din.ReadDecimal()
        self.trafficOut = din.ReadDecimal()
        self.packetIn = din.ReadDecimal()
        self.packetOut = din.ReadFloat()
        self.errorIn = din.ReadFloat()
        self.errorOut = din.ReadInt()
        self.droppedOut = din.ReadDouble()
        self.droppedIn = din.ReadDouble()
        self.count = dinReadInt()

