from whatap.pack.pack_enum import PackEnum
from whatap.pack.pack import Pack
from whatap.io.data_outputx import DataOutputX

from whatap.io.data_inputx import DataInputX

class SMDiskPack(Pack):
    def __init__(self):
        Pack.__init__(self)
        self.os = None
        self.disk = []

    def getPackType(self):
        return PackEnum.PACK_SM_DISK_QUATA

    def write(self, dout):
        super(SMDiskPack, self).write(dout)
        dout.writeShort(self.os)
        dout.writeDecimal(len(self.disk))
        for d in self.disk:
            d.write(dout)

    def read(self, din):
        din = DataInputX(din.readBlob())
        super(SMDiskPack, self).read(din)
        self.os = din.readShort()
        diskCount = din.readDecimal()
        for i in range(diskCount):
            d = DiskPerf()
            d.read(din)
            self.disk.append(d)

class DiskPerf:
    def __init__(self):
        self.mountPoint = None
        self.deviceId = None
        self.fileSystem = None
        self.totalSpace = None
        self.usedSpace = None
        self.usedPercent = None
        self.freeSpace = None
        self.freePercent = None
        self.blksize = None
        self.readIops = 0
        self.writeIops = 0
        self.readBps = 0
        self.writeBps = 0
        self.ioPercent = 0
        self.queueLength = 0

    def write(self, doutx ):
        dout= DataOutputX()
        dout.writeInt(self.deviceId)
        dout.writeInt(self.mountPoint)
        dout.writeInt(self.fileSystem)
        dout.writeDecimal(self.freeSpace)
        dout.writeDecimal(self.usedSpace)
        dout.writeDecimal(self.totalSpace)
        dout.writeFloat(self.freePercent)
        dout.writeFloat(self.usedPercent)
        dout.writeInt(self.blksize)
        dout.writeDouble(self.readIops)
        dout.writeDouble(self.writeIops)
        dout.writeDouble(self.readBps)
        dout.writeDouble(self.writeBps)
        dout.writeFloat(self.ioPercent)
        dout.writeInt(1)
        dout.writeFloat(self.queueLength)

        doutx.writeBlob(dout.toByteArray())

    def read(self, dinx):
        din= DataInputX(dinx.readBlob())
        self.deviceId= din.ReadInt()
        self.mountPoint= din.ReadInt()
        self.fileSystem = din.ReadInt()
        self.freeSpace = din.ReadDecimal()
        self.usedSpace = din.ReadDecimal()
        self.totalSpace = din.ReadDecimal()
        self.freePercent = din.ReadFloat()
        self.usedPercent = din.ReadFloat()
        self.blksize = din.ReadInt()
        self.readIops = din.ReadDouble()
        self.writeIops = din.ReadDouble()
        self.readBps = din.ReadDouble()
        self.writeBps = din.ReadDouble()
        self.ioPercent = dinReadFloat()
        self.count = dinReadInt()
        self.queueLength = dinReadFloat()

