import platform
import os

_getcpumemory = None
_getcpunum = None
_getcpu = None
_getmemory = None
_getswapmemory = None
_getcpustat = None
_getcpucore = None
_getcputype = None
_getmemorysize = None
_getdisk = None
_getalldisk = None
_getdiskio = None
_initzfsinfo = None
_getzfsinfo = None
_initDisk = None
_endDisk = None
_getnet = None
_getallnet = None
_getproc = None
_getallproc = None
_gettopnandgroupproc = None
_getlogevent = None
_initlogevent = None
_getfilecheckevents = None
_initfilecheckevent = None
_getmachinearc = None
_getServerInfoV2 = None
_initSysLogRedirect = None

processes = []
system = platform.system().lower()

class _DiskPerf:
    UNSUPPORTED = -1

    def __init__(self):
        self.mountPoint = None
        self.deviceId = None
        self.fileSystem = None
        self.totalSpace = 0
        self.usedSpace = 0
        self.usedPercent = 0.0
        self.freeSpace = 0
        self.freePercent = 0.0
        self.blksize = 0
        self.readIops = 0
        self.writeIops = 0
        self.totalIops = 0
        self.readBps = 0
        self.writeBps = 0
        self.totalBps = 0
        self.readTime = _DiskPerf.UNSUPPORTED
        self.writeTime = _DiskPerf.UNSUPPORTED
        self.totalBusyTime = _DiskPerf.UNSUPPORTED
        self.totalWaitTime = _DiskPerf.UNSUPPORTED
        self.ioPercent = 0
        self.queueLength = 0
        self.inodePercent = 0

    def __str__(self):
        buf = StringIO()
        buf.write('mountPoint=')
        buf.write(self.mountPoint) 
        buf.write('\ndeviceId=')
        buf.write(self.deviceId)
        buf.write('\nfileSystem=')
        buf.write(self.fileSystem)
        buf.write('\ntotalSpace=')
        buf.write(self.totalSpace)
        buf.write('\nusedSpace=')
        buf.write(self.usedSpace)
        buf.write('\nusedPercent=')
        buf.write(self.usedPercent)
        buf.write('\nfreeSpace=')
        buf.write(self.freeSpace)
        buf.write('\nfreePercent=')
        buf.write(self.freePercent)
        buf.write('\nself.blksize=')
        buf.write(self.blksize)
        buf.write('\nreadIops=')
        buf.write(self.readIops)
        buf.write('\nwriteIops=')
        buf.write(self.writeIops)
        buf.write('\nreadBps=')
        buf.write(self.readBps)
        buf.write('\nwriteBps=')
        buf.write(self.writeBps)
        buf.write('\nioPercent=')
        buf.write(self.ioPercent)
        buf.write('\nqueueLength=')
        buf.write(self.queueLength)

        return buf.getvalue()


class CPUStat:
    # -1 unsuppoerted
    UNSUPPORTED = -1

    def __init__(self):
        self.runqueue = 0
        self.blockqueue = 0
        self.pendingqueue = 0
        self.waitqueue = 0
        self.forkCount = 0
        self.execCount = 0
        self.ctx = 0
        self.interrupt = 0
        self.syscall = 0


if 'linux' == system:
    import cpu_memory as cpu_memory
    _getcpumemory = cpu_memory.GetCpuMemory

    import system_info_linux as system_info
    _getcpunum = system_info.GetCPUNum
    _getcputype = system_info.GetCPUType
    _getmemorysize = system_info.GetMemorySize
    _getOSRelease = system_info.GetOSRelease
    import disk_linux
    _getdisk = disk_linux.getDisk
    import network_linux
    _getnet = network_linux.GetNicUtil
    import proc_linux
    _getproc = proc_linux.GetProc
    import log_event_linux
    _getlogevent = log_event_linux.getNewLogEvents
    _initlogevent = log_event_linux.initFileLogWatcher
    import file_check_event
    _getfilecheckevents = file_check_event.get_file_check_events
    _initfilecheckevent = file_check_event.init_file_check_watcher
    _getmachinearc = system_info.GetMachineArch
elif 'sunos' == system:
    import cpu_memory_sunos as cpu_memory
    _getcpumemory = cpu_memory.GetCpuMemory
    _getcpu = cpu_memory.GetCpu
    _getmemory = cpu_memory.GetMemory
    _getswapmemory = cpu_memory.GetSwapMemory
    _getcpustat = cpu_memory.GetCpuStat
    _getcpucore = cpu_memory.GetCpuCore
    import system_info_sunos as system_info
    import system_info_sunos
    _getcpunum = system_info_sunos.GetCPUNum
    _getcputype = system_info_sunos.GetCPUType
    _getmemorysize = system_info_sunos.GetMemorySize
    _getOSRelease = system_info_sunos.GetOSRelease
    import disk_sunos 
    _getdisk = disk_sunos.getDisk #fs
    _getalldisk = disk_sunos.getDiskIoInfo
    _getdiskio = disk_sunos.GetDiskIO
    _getzfsinfo = disk_sunos.GetZfsInfo
    _initzfsinfo = disk_sunos.initUpdateZfs
    import network_sunos
    _getnet = network_sunos.GetNicUtil
    _getallnet = network_sunos.GetNetInfo
    import proc_sunos
    _getproc = proc_sunos.GetProc
    _getallproc = proc_sunos.GetTotalProc
    _gettopnandgroupproc = proc_sunos.GetTopNAndGroupProc
    import log_event_linux
    _getlogevent = log_event_linux.getNewLogEvents
    _initlogevent = log_event_linux.initFileLogWatcher
    import file_check_event
    _getfilecheckevents = file_check_event.get_file_check_events
    _initfilecheckevent = file_check_event.init_file_check_watcher
    _getmachinearc = system_info_sunos.GetMachineArch
    _getServerInfoV2 = system_info_sunos.GetServerInfoV2
elif 'aix' == system: 
    os.environ['LANG'] = 'en_US'
    import cpu_memory_aix as cpu_memory
    _getcpumemory = cpu_memory.GetCpuMemory
    _getcpu = cpu_memory.GetCpu
    _getmemory = cpu_memory.GetMemory
    _getswapmemory = cpu_memory.GetSwapMemory
    _getcpustat = cpu_memory.GetCpuStat
    _getcpucore = cpu_memory.GetCpuCore
    import system_info_aix as system_info
    import system_info_aix 
    _getcpunum = system_info_aix.GetCPUNum
    _getcputype = system_info_aix.GetCPUType
    _getmemorysize = system_info_aix.GetMemorySize
    _getOSRelease = system_info_aix.GetOSRelease
    _initSysLogRedirect = system_info_aix.InitErrptRedirect
    import disk_aix 
    _getdisk = disk_aix.getDisk
    _getalldisk = disk_aix.GetDiskTotalIO
    _getdiskio = disk_aix.GetDiskIO
    import network_aix
    _getnet = network_aix.GetNicUtil
    _getallnet = network_aix.GetNetInfo
    import proc_aix
    _getproc = proc_aix.GetProc
    _getallproc = proc_aix.GetTotalProc
    _gettopnandgroupproc = proc_aix.GetTopNAndGroupProc
    import log_event_linux
    _getlogevent = log_event_linux.getNewLogEvents
    _initlogevent = log_event_linux.initFileLogWatcher
    import file_check_event
    _getfilecheckevents = file_check_event.get_file_check_events
    _initfilecheckevent = file_check_event.init_file_check_watcher
    _getmachinearc = system_info_aix.GetMachineArch
    _getServerInfoV2 = system_info_aix.GetServerInfoV2
elif 'hp-ux' == system:
    import cpu_memory_hpux as cpu_memory
    _getcpumemory = cpu_memory.GetCpuMemory
    _getcpu = cpu_memory.GetCpu
    _getmemory = cpu_memory.GetMemory
    _getswapmemory = cpu_memory.GetSwapMemory
    _getcpustat = cpu_memory.GetCpuStat
    _getcpucore = cpu_memory.GetCpuCore

    import system_info_hpux as system_info
    _getcpunum = system_info.GetCPUNum
    _getcputype = system_info.GetCPUType
    _getmemorysize = system_info.GetMemorySize
    _getOSRelease = system_info.GetOSRelease
    _getmachinearc = system_info.GetMachineArch
    import disk_hpux
    _getdisk = disk_hpux.getDisk
    _getalldisk = disk_hpux.GetDiskTotalIO
    _getdiskio = disk_hpux.GetDiskIO
    import proc_hpux
    _getproc = proc_hpux.GetProc
    _getallproc = proc_hpux.GetTotalProc
    _gettopnandgroupproc = proc_hpux.GetTopNAndGroupProc
    import network_hpux
    _getnet = network_hpux.GetNicUtil
    _getallnet = network_hpux.GetNetInfo
    import log_event_linux
    _getlogevent = log_event_linux.getNewLogEvents
    _initlogevent = log_event_linux.initFileLogWatcher
    import file_check_event
    _getfilecheckevents = file_check_event.get_file_check_events
    _initfilecheckevent = file_check_event.init_file_check_watcher
    _getServerInfoV2 = system_info_hpux.GetServerInfoV2

def GetCpu():
    if _getcpu == None:
        return None
    return _getcpu()

def GetMemory():
    if _getmemory == None:
        return None
    return _getmemory()

def GetSwapMemory():
    if _getswapmemory == None:
        return None
    return _getswapmemory()

def GetCpuStat():
    if _getcpustat == None:
        return None
    return _getcpustat()

def GetCpuCore():
    if _getcpucore == None:
        return None
    return _getcpucore()

def GetCpuMemory():
    if _getcpumemory == None:
        return None
    return _getcpumemory()

def GetCPUNum():
    if _getcpunum == None:
        return None
    return _getcpunum()

def GetCPUType():
    if _getcputype == None:
        return None
    return _getcputype()

def GetMemorySize():
    if _getmemorysize == None:
        return None
    return _getmemorysize()

def GetUptime():
    import time
    return int(time.time())

def GetDisk():
    if _getdisk == None:
        return None
    return _getdisk()

def GetTotalDisk():
    if _getalldisk == None:
        return None
    return _getalldisk()

def GetDiskIO():
    if _getdiskio == None:
        return None
    return _getdiskio()

def InitZfsInfo():
    if _initzfsinfo == None:
        return None
    return _initzfsinfo()

def GetZfsInfo():
    if _getzfsinfo == None:
        return None
    return _getzfsinfo()

def GetNicUtil():
    if _getnet == None:
        return None
    return _getnet()

def GetTotalNet():
    if _getallnet == None:
        return None
    return _getallnet()

def GetProc():
    if _getproc == None:
        return None
    return _getproc()

def GetTotalProc():
    if _getallproc == None:
        return None, None, None
    return _getallproc()

def GetTopNAndGroupProc(n):
    if _gettopnandgroupproc == None:
        return None, None
    return _gettopnandgroupproc(n)

def GetLogEvents():
    if _getlogevent == None:
        return None
    return _getlogevent()

def InitLogEvent():
    if _initlogevent == None:
        return None
    _initlogevent()

def GetFileCheckEvents():
    if _getfilecheckevents == None:
        return None
    return _getfilecheckevents()

def InitFileCheckEvent():
    if _initfilecheckevent == None:
        return None
    _initfilecheckevent()

def GetMachineArch():
    if _getmachinearc == None:
        return None
    return _getmachinearc()

import tcp_check

def TCPCheckSchedule(checkurl, timeout, onPerf):
    return tcp_check.tcpCheckSchedule(checkurl, timeout, onPerf)

def GetOSRelease():
    if _getOSRelease == None:
        return None
    return _getOSRelease()

def GetServerInfoV2():
    if _getServerInfoV2 == None:
        return None
    return _getServerInfoV2()

def GetLCore():
    lcore = 0
    try:
        lcore = int(GetServerInfoV2()["lCores"])
    except ValueError, e:
        lcore = 0

    return lcore

def InitSyslogRedirect():
    if _initSysLogRedirect == None:
        return
    _initSysLogRedirect()
    
