import logging
from logging.handlers import TimedRotatingFileHandler

def setup_logger(log_file_path, log_level=logging.INFO):
    logger = logging.getLoggero("MyLogger")
    logger.propagate = False
    logger.setLevel(log_level)

    #formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(filename)s:%(lineno)d - %(funcName)s - %(message)s')
    formatter = logging.Formatter('[%(asctime)s] [%(levelname)s] [%(message)s] [%(filename)s:%(funcName)s:%(lineno)d]')

    handler = TimedRotatingFileHandler(
        log_file_path,
        when="midnight",
        interval=1
    )
    
    handler.setFormatter(formatter)
    handler.setLevel(log_level)

    if logger.handlers:
        logger.handlers = []
  
    logger.addHandler(handler)
    return logger

log_file = "./logfile.log"

logger = setup_logger(log_file, logging.INFO)

def example_function():
    logger.info("This is an INFO message from example_function.")
    logger.error("This is an ERROR message from example_function.")
    logger.debug("This is a DEBUG message.")
    logger.info("This is an INFO message.")
    logger.warning("This is a WARNING message.")
    logger.error("This is an ERROR message.")
    logger.critical("This is a CRITICAL message.")

example_function()

