import whatap.pack.smlogevent_pack as smlogevent_pack
from whatap.pack.smlogevent_pack import SMLogEventPack
from whatap.pack.smlogevent_pack import SMLogEvent
import whatap.osinfo as osinfo


class TaskLogEvent:
    def __init__(self):
        osinfo.InitLogEvent()
        osinfo.InitFileCheckEvent()

    def interval(self):
        return 5

    def process(self, os_, pcode, oid, now):
        p = SMLogEventPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now

        event_count = 0

        # Log file events
        logEvents = osinfo.GetLogEvents()
        if logEvents:
            for logEvent in logEvents:
                l = SMLogEvent()
                l.filePath = logEvent.filePath
                l.logContent = logEvent.logContent
                l.eventSource = smlogevent_pack.EVENTSOURCE_FILE
                l.severity = logEvent.severity
                l.logRule = logEvent.triggerId
                l.keyword = logEvent.keyword
                p.logEvent.append(l)
                event_count += 1

        # File check events
        fileCheckEvents = osinfo.GetFileCheckEvents()
        if fileCheckEvents:
            for fcEvent in fileCheckEvents:
                l = SMLogEvent()
                l.logRule = fcEvent.trigger_id
                l.filePath = fcEvent.file_path
                l.previous = fcEvent.before
                l.current = fcEvent.current
                l.eventSource = smlogevent_pack.EVENTSOURCE_FILE_WATCH
                l.severity = fcEvent.severity
                l.checkType = fcEvent.check_type
                l.elapsed = fcEvent.elapsed
                p.logEvent.append(l)
                event_count += 1

        if event_count > 0:
            return p
        else:
            return None
