import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure

class TaskInfraSwap:
    SWAP = "infra_swap"
    SWAP_SIZE = "size"
    SWAP_PUSED = "pUsed"
    SWAP_USED = "used"

    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        swap = osinfo.GetSwapMemory()

        if not swap:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraSwap.SWAP
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        p.put(TaskInfraSwap.SWAP_SIZE, swap.swapTotal)
        p.put(TaskInfraSwap.SWAP_PUSED, swap.swapPused)
        p.put(TaskInfraSwap.SWAP_USED, swap.swapUsed)

        return p

 

