import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure

class TaskInfraProcess:
    PROCESS = "infra_process"
    PROCESS_COUNT = "procTotal"
    PROCESS_THREAD_COUNT = "threadTotal"
    PROCESS_DEFUNCT_COUNT = "defunctTotal"
    
    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        proc, thread, defunct = osinfo.GetTotalProc()
        
        if not proc:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraProcess.PROCESS
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        p.put(TaskInfraProcess.PROCESS_COUNT, proc)
        p.put(TaskInfraProcess.PROCESS_THREAD_COUNT, thread)
        p.put(TaskInfraProcess.PROCESS_DEFUNCT_COUNT, defunct)
        return p
