import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure

class TaskInfraNetwork:
    NETWORK = "infra_network"
    NETWORK_RX_BITPS = "rxbps" 
    NETWORK_TX_BITPS = "txbps"
    NETWORK_TOTAL_BITPS = "totalbps"
    NETWORK_RX_PPS = "rxpps"
    NETWORK_TX_PPS = "txpps"
    NETWORK_TOTAL_PPS = "totalpps"

    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        net = osinfo.GetTotalNet()
        if not net:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraNetwork.NETWORK
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        p.put(TaskInfraNetwork.NETWORK_RX_BITPS, net.trafficIn)
        p.put(TaskInfraNetwork.NETWORK_TX_BITPS, net.trafficOut)
        p.put(TaskInfraNetwork.NETWORK_TOTAL_BITPS, net.trafficIn + net.trafficOut)
        p.put(TaskInfraNetwork.NETWORK_RX_PPS, net.packetIn)
        p.put(TaskInfraNetwork.NETWORK_TX_PPS, net.packetOut)
        p.put(TaskInfraNetwork.NETWORK_TOTAL_PPS, net.packetIn + net.packetOut)

        return p

 


