import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure

class TaskInfraMem:
    MEM = "infra_mem"
    MEM_PUSED = "pUsed"
    MEM_USED = "used"
    MEM_PCACHE = "pCache"
    MEM_CACHE = "cache"
    MEM_PUSED_PCACHE = "pUsed_pCache"
    MEM_SIZE = "size"
    MEM_SWAPIN = "swapIn"
    MEM_SWAPOUT = "swapOut"
    MEM_FILESYSTEMIN = "fsIn"
    MEM_FILESYSTEMOUT = "fsOut"
    MEM_SCANNED = "scanned"
    MEM_FREED = "freed"

    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        mem = osinfo.GetMemory()

        if not mem:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraMem.MEM
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        p.put(TaskInfraMem.MEM_PUSED, mem.pused)
        p.put(TaskInfraMem.MEM_USED, mem.used)
        pCache = float(float(mem.cached)/float(mem.total)*100.0)
        p.put(TaskInfraMem.MEM_PCACHE, pCache)
        p.put(TaskInfraMem.MEM_CACHE, mem.cached)
        p.put(TaskInfraMem.MEM_PUSED_PCACHE, mem.pused + pCache)
        p.put(TaskInfraMem.MEM_SIZE, mem.total)
        
        p.put(TaskInfraMem.MEM_SWAPIN, mem.swapIn)
        p.put(TaskInfraMem.MEM_SWAPOUT, mem.swapOut)
        p.put(TaskInfraMem.MEM_FILESYSTEMIN, mem.fileSystemIn)
        p.put(TaskInfraMem.MEM_FILESYSTEMOUT, mem.fileSystemOut )
        p.put(TaskInfraMem.MEM_SCANNED, mem.scannedPage)
        p.put(TaskInfraMem.MEM_FREED, mem.freedPage)

        return p

     
