import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure


class TaskInfraCPU:
    CPU = "infra_cpu"
    CPU_TOTAL = "total"
    CPU_USER = "user"
    CPU_SYS = "sys"
    CPU_NICE = "nice"
    CPU_WAIT = "wait"
    CPU_TOTAL_WAIT = "total_wait"
    CPU_IDLE = "idle"
    CPU_LCORES = "lCores"
    CPU_IRQ = "irq"
    CPU_SOFTIRQ = "softirq"
    CPU_STEAL = "steal"
    CPU_LOADAVG_1 = "loadavg_1m"
    CPU_LOADAVG_5 = "loadavg_5m"
    CPU_LOADAVG_15 = "loadavg_15m"

    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        cpu = osinfo.GetCpu()

        if not cpu:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraCPU.CPU
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        total = cpu.system + cpu.user + cpu.nice
        p.put(TaskInfraCPU.CPU_TOTAL, total)
        p.put(TaskInfraCPU.CPU_USER, cpu.user)
        p.put(TaskInfraCPU.CPU_SYS, cpu.system)
        p.put(TaskInfraCPU.CPU_NICE, cpu.nice)
        p.put(TaskInfraCPU.CPU_WAIT, cpu.iowait)
        p.put(TaskInfraCPU.CPU_TOTAL_WAIT, total + cpu.iowait)
        p.put(TaskInfraCPU.CPU_IDLE, cpu.idle)
        p.put(TaskInfraCPU.CPU_LCORES, int(osinfo.GetLCore()))
        #p.put(TaskInfraCPU.CPU_IRQ, cpu.irq)
        #p.put(TaskInfraCPU.CPU_SOFTIRQ, cpu.softirq)
        #p.put(TaskInfraCPU.CPU_STEAL, cpu.steal)
        p.put(TaskInfraCPU.CPU_LOADAVG_1, cpu.load1)
        p.put(TaskInfraCPU.CPU_LOADAVG_5, cpu.load5)
        p.put(TaskInfraCPU.CPU_LOADAVG_15, cpu.load15)

        return p

        
