import whatap.agent.secure.security_master as secure
import whatap.agent.data.data_text as data
from whatap.pack.pack_enum import PackEnum
import whatap.pack as pack
from whatap.util.date_util import DateUtil as dateutil
import whatap.net as net
import whatap.agent.conf.configure as conf
from whatap.util.ip_util import IPUtil as iputil
import platform, os
import whatap.osinfo as osinfo



class TaskExtraINFO:
    def __init__(self, agent_version = ""):
	    self.firstSent = False
            self.agent_version = agent_version

    def interval(self):
        if self.firstSent:
            return 300
        else:
            return 5

    def process(self, os_ , pcode , oid , now ) :
        secu = secure.GetSecurityMaster()
        if secu.oid == 0 :
            return None

        self.firstSent = True
        data.sendHashText(PackEnum.TEXT_ONAME, secu.oid, secu.oname)

        return self.sendBootEnv()

    def sendBootEnv(self):
        secu = secure.GetSecurityMaster()
        p = pack.NewParamPack()
        p.pcode = secure.GetSecurityMaster().pcode
        p.oid = secure.GetSecurityMaster().oid
        p.time = dateutil.now()
        p.id = net.PARAM_AGENT_BOOT_ENV
        config = conf.GetConfig()
        p.putString("whatap.version", self.agent_version)
        p.putString("whatap.home", config.WhatapHome)
        p.putString("whatap.name", secu.oname)
        p.putString("whatap.ip", iputil.toString(secu.ip))
        p.putString("whatap.public_ip", iputil.toString(secu.publicip))
        p.putString("whatap.pid", "%d" % os.getpid())
        p.putLong("java.start", dateutil.now())

        p.putString("os.arch", osinfo.GetMachineArch())
        osRelease = osinfo.GetOSRelease()
        p.putString("os.name", osRelease.split()[0].lower())
        p.putString("os.cpucore", str(osinfo.GetCPUNum()))
        cpuType = osinfo.GetCPUType()
        p.putString("os.cpuvendor", cpuType)
        memorySize = osinfo.GetMemorySize()
        p.putString("os.memory", str(memorySize))
        p.putString("os.release", osRelease) 
        p.putLong("sms.starttime", dateutil.now())
        p.putString("agent.tags", ",".join(config.Tags))
        p.putLong("infra.createdtime", int(config.CreatedTime))

        return p
