import threading, time
import whatap.agent.secure.security_master as secure
import whatap.agent.data.data_text as data
from whatap.pack.pack_enum import PackEnum
import whatap.pack.smdisk_pack as smdisk_pack
import whatap.osinfo as osinfo
from whatap.util.hash_util import HashUtil as hash

class TaskDisk:
    def __init__(self):
        pass

    def interval(self):
        return 5

    def process(self, os_ , pcode , oid , now ) :
        diskperfs = osinfo.GetDisk()
        if not diskperfs:
            return None

        d= smdisk_pack.SMDiskPack()
        d.pcode = pcode
        d.oid = oid
        d.time = now
        d.os = os_
        disk = []
        for diskperf in diskperfs:
            p = smdisk_pack.DiskPerf()
            p.blksize = diskperf.blksize
            p.deviceId = hash.hash(diskperf.deviceId)
            data.sendHashText(PackEnum.TEXT_SYS_DEVICE_ID, p.deviceId, diskperf.deviceId)
            p.fileSystem = hash.hash(diskperf.fileSystem)
            data.sendHashText(PackEnum.TEXT_SYS_FILE_SYSTEM, p.fileSystem, diskperf.fileSystem)
            p.freePercent = diskperf.freePercent
            p.freeSpace = diskperf.freeSpace
            p.mountPoint = hash.hash(diskperf.mountPoint)
            data.sendHashText(PackEnum.TEXT_SYS_MOUNT_POINT, p.mountPoint, diskperf.mountPoint)
            p.readBps = diskperf.readBps
            p.readIops = diskperf.readIops
            p.totalSpace = diskperf.totalSpace
            p.usedPercent = diskperf.usedPercent
            p.usedSpace = diskperf.usedSpace
            p.writeBps = diskperf.writeBps
            p.writeIops = diskperf.writeIops
            p.ioPercent = diskperf.ioPercent
            p.queueLength = diskperf.queueLength
            disk.append(p)

        d.disk = disk

        return d
