import threading, time
import whatap.agent.secure.security_master as secure
import whatap.agent.data.data_text as data
from whatap.pack.pack_enum import PackEnum
import whatap.pack.smbase_pack as smbase_pack
import whatap.osinfo as osinfo

class TaskBase:


    def __init__(self):
        pass

    def interval(self):
        return 5

    def process(self, os_ , pcode , oid , now ) :
        cpu, memory, uptime = osinfo.GetCpuMemory()
        if not cpu or not memory or not uptime:
            return None

        #print 'TaskBase.process step -1', cpu, memory, uptime
        p= smbase_pack.SMBasePack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.os = os_
        p.cpu = cpu
        p.cpuCore = []
        p.memory = memory
        p.upTime = uptime
        p.epochTime = int(now /1000)
        p.ip = secure.GetSecurityMaster().ip

        return p
