import time

class Tag(object):
    def __init__(self, key, value):
        self.Key = key
        self.Value = value

class Field(object):
    def __init__(self, key, value):
        self.Key = key
        self.Value = value

class Metric(object):
    def __init__(self):
        self.name = ""
        self.tags = {}
        self.tagList = []
        self.fields = {}
        self.field_list = []
        self.timestamp = time.time()

    def getName(self):
        return self.name

    def getTags(self):
        return self.tags

    def getTagList(self):
        return self.tagList

    def getFields(self):
        return self.fields

    def getFieldList(self):
        return self.field_list

    def getTime(self):
        return self.timestamp

    def setName(self, name):
        self.name = name

    def addPrefix(self, prefix):
        self.name = prefix + self.name

    def addSuffix(self, suffix):
        self.name = self.name + suffix

    def getTag(self, key):
        return self.tags.get(key, None)

    def hasTag(self, key):
        return key in self.tags

    def addTag(self, key, value):
        self.tags[key] = value
        self.tagList.append(Tag(key, value))

    def removeTag(self, key):
        if key in self.tags:
            del self.tags[key]
            self.tagList = [tag for tag in self.tagList if tag.Key != key]

    def getField(self, key):
        return self.fields.get(key, None)

    def hasField(self, key):
        return key in self.fields

    def addField(self, key, value):
        self.fields[key] = value
        self.field_list.append(Field(key, value))

    def removeField(self, key):
        if key in self.fields:
            del self.fields[key]
            self.field_list = [field for field in self.field_list if field.Key != key]

    def setTime(self, t):
        self.timestamp = t

    def hashId(self):
        return hash(self.name)

    def copy(self):
        newMetric = Metric()
        newMetric.name = self.name
        newMetric.tags = self.tags.copy()
        newMetric.tagList = self.tagList.copy()
