import codecs
import os

def getScanner(encoding, f):
    fsEncoding = encoding.lower()

    if fsEncoding in ["shift-jis", "shift_jis"]:
        reader = codecs.getreader('shift_jis')
    elif fsEncoding in ["euc-jp", "euc_jp"]:
        reader = codecs.getreader('euc_jp')
    elif fsEncoding in ["iso2022-jp", "iso2022_jp"]:
        reader = codecs.getreader('iso2022_jp')
    elif fsEncoding in ["euc-kr", "euc_kr"]:
        reader = codecs.getreader('euc_kr')
    elif fsEncoding == "utf-16le":
        reader = codecs.getreader('utf_16_le')
    elif fsEncoding == "utf-16be":
        reader = codecs.getreader('utf_16_be')
    else:
        try:
            reader = codecs.getreader(encoding)
        except LookupError:
            raise ValueError("Invalid encoding error: {}".format(encoding))

    return reader(f, 'strict')

# # Example usage:
# with open("your_file.txt", "rb") as file:
#     scanner = get_scanner("utf-8", file)
#     for line in scanner:
#         print(line)
