

units = {"": 1, "b": 1, "kb": 2**10, "mb": 2**20, "gb": 2**30, "tb": 2**40}

# Alternative unit definitions, notably used by Windows:
# units = {"B": 1, "KB": 2**10, "MB": 2**20, "GB": 2**30, "TB": 2**40}

def parse_size(size, default):
    size = size.lower()
    try:
        number, unit = [string.strip() for string in size.split()]
        return int(float(number)*units[unit])
    except Exception, e:
        return default
    