from whatap.io.data_outputx import DataOutputX
from whatap.io.data_inputx import DataInputX
from whatap.pack.pack import Pack
from whatap.pack.pack_enum import PackEnum

EVENTSOURCE_FILE       = 1
EVENTSOURCE_WINEVENT   = 2
EVENTSOURCE_SCRIPT     = 3
EVENTSOURCE_AUDIT      = 4
EVENTSOURCE_FILE_WATCH = 5


class SMLogEvent :
	def __init__(self):
		self.eventSource = None
		self.severity = None
		self.filePath = None
		self.logContent = None

		self.winLogFile = None
		self.winType = 0
		self.winSourceName = None
		self.winEventCode = 0
		self.winCreateTime = 0

		self.keyword = None
		self.logRule = None

		# File check fields (for EVENTSOURCE_FILE_WATCH)
		self.checkType = 0
		self.previous = None
		self.current = None
		self.elapsed = 0

	def write(self, out):
		dout = DataOutputX()
		dout.writeByte(self.eventSource)

		dout.writeByte(self.severity)
		if self.filePath:
			dout.writeText( self.filePath)
		else:
			dout.writeText("")

		if self.logContent:
			dout.writeText( self.logContent )
		else:
			dout.writeText("")

		if self.winLogFile :
			dout.writeText( self.winLogFile)
		else:
			dout.writeText("")

		dout.writeInt(self.winType)
		if self.winSourceName :
			dout.writeText( self.winSourceName)
		else :
			dout.writeText("")


		dout.writeInt(self.winEventCode)
		dout.writeLong(self.winCreateTime)

		if self.keyword:
			dout.writeText( self.keyword)
		else:
			dout.writeText("")

		if self.logRule:
			dout.writeText( self.logRule)
		else:
			dout.writeText("")

		# File check fields
		dout.writeByte(self.checkType if self.checkType else 0)
		if self.previous:
			dout.writeText(self.previous)
		else:
			dout.writeText("")
		if self.current:
			dout.writeText(self.current)
		else:
			dout.writeText("")
		dout.writeInt(self.elapsed if self.elapsed else 0)

		out.writeBlob(dout.toByteArray())

	def read(self, inx):
		din = DataInputX( inx.readBlob())

		self.eventSource = din.readByte()
		self.severity = din.readByte()
		filepath = din.readText()
		self.filePath = filepath
		logcontent = din.readText()
		self.logContent = logcontent

		winlogfile = din.readText()
		self.winLogFile = winlogfile
		self.winType = din.readInt()
		winsourcename = din.readText()
		self.winSourceName = winsourcename
		self.winEventCode = din.readInt()
		self.winCreateTime = din.readLong()

		keyword = din.readText()
		self.keyword = keyword

		logRule = din.readText()
		self.logRule = logRule

		# File check fields
		self.checkType = din.readByte()
		self.previous = din.readText()
		self.current = din.readText()
		self.elapsed = din.readInt()


class SMLogEventPack(Pack):
	def __init__(self):
		self.logEvent = []

	def getPackType(self):
		return PackEnum.PACK_SM_LOG_EVENT

	def write(self, dout):
		super(SMLogEventPack, self).write(dout)

		dout.writeDecimal(len(self.logEvent))
		for logEvent in self.logEvent:
			logEvent.write(dout)

	def read(self, din):
		super(SMLogEventPack, self).read(din)
		eventCount = din.readDecimal()
		if eventCount:
			for i in range(eventCount):
				logevent = SMLogEvent()
				self.logEvent.append(logevent.read(din))
