class PackEnum(object):
    PARAMETER = 0x0100
    COUNTER = 0x0200
    COUNTER_1 = 0x0201
    PROFILE = 0x0300
    ACTIVESTACK = 0x0400
    TEXT = 0x0700
    ERROR_SNAP = 0x0800
    ERROR_SNAP_1 = 0x0801
    REALTIME_USER = 0x0f00

    STAT_SERVICE = 0x0900
    STAT_SQL = 0x0a00
    STAT_HTTPC = 0x0b00
    STAT_ERROR = 0x0c00
    STAT_METHOD = 0x0e00
    STAT_TOP_SERVICE = 0x1000
    STAT_REMOTE_IP = 0x1100
    STAT_USER_AGENT = 0x1200

    EVENT = 0x1400
    HITMAP = 0x1500
    HITMAP_1 = 0x1501
    EXTENSION = 0x1600
    COMPOSITE = 0x1700

    PACK_PARAMETER = 0x0100
    PACK_COUNTER_JAVA = 0x0200
    PACK_TEXT = 0x0700

    PACK_EXTENSION = 0x1600
    PACK_COMPOSITE = 0x1700

    PACK_SM_BASE = 0x3008
    PACK_SM_DISK_QUATA = 0x3001
    PACK_SM_NET_PERF = 0x3002
    PACK_SM_PROC_PERF = 0x3003
    PACK_SM_PORT_PERF = 0x3004
    PACK_SM_LOG_EVENT = 0x3005
    PACK_SM_DOWN_CHECK = 0x3006
    PACK_SM_EXTENSION = 0x1600

    PACK_SM_NUT = 0x3010
    PACK_SM_ATTR = 0x3011
    PACK_TAGCOUNT = 0x1601
    PACK_LOGSINK = 0x170a

    @staticmethod
    def create(p):
        if p == PackEnum.PACK_PARAMETER:
            from whatap.pack.param_pack import ParamPack
            return ParamPack()
        elif p == PackEnum.PACK_TEXT:
            return TextPack()
        elif p == PackEnum.PACK_EXTENSION:
            return NewExtensionPack()
        elif p == PackEnum.PACK_SM_BASE:
            from whatap.pack.smbase_pack import SMBasePack
            return SMBasePack()
        elif p == PackEnum.PACK_SM_DISK_QUATA:
            return NewSMDiskPerfPack()
        elif p == PackEnum.PACK_SM_NET_PERF:
            return NewSMNetPerfPack()
        elif p == PackEnum.PACK_SM_PROC_PERF:
            return NewSMProcPerfPack()
        elif p == PackEnum.PACK_SM_LOG_EVENT:
            return NewSMLogEventPack()
        elif p == PackEnum.PACK_SM_DOWN_CHECK:
            return NewSMDownCheckPack()
        else:
            raise Exception('packtype %d not supported'%(p))

    TEXT_SERVICE = 1
    TEXT_SQL = 2
    TEXT_DB_URL = 3
    TEXT_HTTPC_URL = 4
    TEXT_ERROR = 5
    TEXT_METHOD = 6
    TEXT_STACK_ELEMENTS = 7
    TEXT_REFERER = 8
    TEXT_USER_AGENT = 9
    TEXT_HTTPC_HOST = 10
    TEXT_MESSAGE = 11
    TEXT_CRUD = 12
    TEXT_ONAME = 13
    TEXT_COMMAND = 14

    TEXT_SYS_DEVICE_ID = 21
    TEXT_SYS_MOUNT_POINT = 22
    TEXT_SYS_FILE_SYSTEM = 23
    TEXT_SYS_NET_DESC = 24
    TEXT_SYS_PROC_CMD1 = 26
    TEXT_SYS_PROC_CMD2 = 27
    TEXT_SYS_PROC_USER = 28
    TEXT_SYS_PROC_STATE = 29
    TEXT_SYS_PROC_FILENAME = 30
    TEXT_SM_LOG_FILE = 31
    TEXT_EXT_META = 32
