from whatap.pack.pack import Pack
from whatap.pack.pack_enum import PackEnum
from whatap.io.data_outputx import DataOutputX
from whatap.value.map_value import MapValue
import whatap.value.value as value
from whatap.util.hash_util import HashUtil

class LogSinkPack(Pack):
    def __init__(self, category= None):
        Pack.__init__(self)

        self.category = category
        self.taghash = 0
        self.tags = MapValue()
        self.fields = MapValue()
        self.line = 0
        self.content = None

    def getPackType(self):
        return PackEnum.PACK_LOGSINK

    def write(self, dout ):
        super(LogSinkPack, self).write(dout)

        dout.writeByte(0)
        dout.writeText(self.category)
        if self.taghash == 0 and self.tags.size() > 0:
            tagIO = DataOutputX()
            value.writeValue(tagIO, self.tags)
            tagbytes = tagIO.toByteArray()
            self.taghash = HashUtil.hash64(tagbytes)
            dout.writeDecimal(self.taghash)
            dout.write(tagbytes)
        else:
            dout.writeDecimal(self.taghash)
            value.writeValue(dout, self.tags)
        dout.writeDecimal(self.line)
        dout.writeText(self.content)

        if self.fields:
            dout.writeBoolean(True)
            value.writeValue(dout, self.fields)
        else:
            dout.writeBoolean(False)

    def read(self, din ):
        super(LogSinkPack, self).read(din)
        din.readByte()
        self.category = din.readText()
        self.tags = value.readValue(din)
        self.line = value.readDecimal(din)
        self.content = value.readText(din)
        if value.readBoolean(din):
            self.fields = value.readValue(din)

    
