import platform
machineArch = platform.machine()
system_info = {}
f = open('/proc/cpuinfo')
try:
    for l in f.readlines():
        if l and l.find(':') >= 0:
            k, v = l.split(':')
        system_info[k.strip()] = v.strip()
finally:
    f.close()
f = open('/proc/meminfo')
try:
    for l in f.readlines():
        k, v = l.split(':')
        system_info[k.strip()] = v.strip().strip(' kB')
finally:
    f.close()

def GetCPUNum():
    import os
    return os.sysconf('SC_NPROCESSORS_ONLN')

def GetCPUType():
    return system_info['model name']

def GetMemorySize():
    return int(system_info['MemTotal']) * 1024

def GetMachineArch():
    return machineArch


def GetOSRelease():
    return " ".join([platform.system(), platform.release()])
