import re

def parse_svmon_output(output):
    # Regular expression patterns to extract relevant information
    memory_pattern = re.compile(r'^\s*memory\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\w+)$')
    pg_space_pattern = re.compile(r'^\s*pg space\s+(\d+)\s+(\d+)$')
    pin_in_use_pattern = re.compile(r'^\s*pin\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)$')
    in_use_pattern = re.compile(r'^\s*in use\s+(\d+)\s+(\d+)\s+(\d+)$')
    page_size_pattern = re.compile(r'^\s*(\w+)\s+(\d+)\s+(\w+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)$')

    # Initialize variables to store parsed data
    parsed_data = {
        'memory': {},
        'pg_space': {},
        'pin_in_use': {},
        'in_use': {},
        'page_sizes': [],
    }

    # Process each line of the svmon output
    for line in output.split('\n'):
        # Try to match patterns and extract information
        memory_match = memory_pattern.match(line)
        pg_space_match = pg_space_pattern.match(line)
        pin_in_use_match = pin_in_use_pattern.match(line)
        in_use_match = in_use_pattern.match(line)
        page_size_match = page_size_pattern.match(line)

        if memory_match:
            parsed_data['memory'] = {
                'size': int(memory_match.group(1)),
                'inuse': int(memory_match.group(2)),
                'free': int(memory_match.group(3)),
                'pin': int(memory_match.group(4)),
                'virtual': int(memory_match.group(5)),
                'mmode': memory_match.group(6),
            }
        elif pg_space_match:
            parsed_data['pg_space'] = {
                'size': int(pg_space_match.group(1)),
                'inuse': int(pg_space_match.group(2)),
            }
        elif pin_in_use_match:
            parsed_data['pin_in_use'] = {
                'pin': int(pin_in_use_match.group(1)),
                'work': int(pin_in_use_match.group(2)),
                'clnt': int(pin_in_use_match.group(3)),
                'other': int(pin_in_use_match.group(4)),
            }
        elif in_use_match:
            parsed_data['in_use'] = {
                'inuse': int(in_use_match.group(1)),
                'work': int(in_use_match.group(2)),
                'clnt': int(in_use_match.group(3)),
            }
        elif page_size_match:
            page_size_data = {
                'size': page_size_match.group(1),
                'pool_size': int(page_size_match.group(2)),
                'inuse': int(page_size_match.group(3)),
                'pgsp': int(page_size_match.group(4)),
                'pin': int(page_size_match.group(5)),
                'virtual': int(page_size_match.group(6)),
            }
            parsed_data['page_sizes'].append(page_size_data)

    return parsed_data

# Example svmon output
svmon_output = """
               size       inuse        free         pin     virtual   mmode
memory      3997696     3569142      428554      797807     1108012     Ded
pg space    3997696        4338

               work        pers        clnt       other
pin          669492           0        2363      125952
in use      1108012           0     2461130

PageSize   PoolSize       inuse        pgsp         pin     virtual
s    4 KB         -     2684006        4338      176143      222876
m   64 KB         -       55321           0       38854       55321
"""

# # Parse the svmon output
# parsed_data = parse_svmon_output(svmon_output)

# # Display the parsed data
# print("Memory Information:")
# print(parsed_data['memory'])

# print("\nPage Space Information:")
# print(parsed_data['pg_space'])

# print("\nPin and In Use Information:")
# print(parsed_data['pin_in_use'])

# print("\nTotal In Use Information:")
# print(parsed_data['in_use'])

# print("\nPage Size Information:")
# for page_size_data in parsed_data['page_sizes']:
#     print(page_size_data)
