import whatap.util.logging_util as logging_util
import whatap.agent.conf.configure as config
import whatap.agent.secure.security_master as secure
import whatap.net.tcpsession as tcpsession
import whatap.net as net
from whatap.pack.pack import Pack
from whatap.io.data_inputx import DataInputX
from whatap.util.date_util import DateUtil as dateutil
import threading, time, Queue
import math

class __Receiver(threading.Thread):
    def __init__(self) :
        threading.Thread.__init__(self, name='__Receiver')
        self.setDaemon(True)
        self.__queue = Queue.Queue()
        self.__timeSynced = False

    def isTimeSynced(self):
        return self.__timeSynced
        
    def run(self):
        #logging_util.debug('receiver.run step -0.1')
        conf = config.GetConfig()
        secuMaster = secure.GetSecurityMaster()
        #logging_util.debug('receiver.run step -1')
        secuMaster.WaitForInit()
        #logging_util.debug('receiver.run step -2')
        secuSession = secure.GetSecuritySession()
        #logging_util.debug('receiver.run step -3')
        while True:
            try:
                #logging_util.debug('receiver.run step -4')
                session = tcpsession.GetTcpSession()
                while not session.isOpen():
                    session = tcpsession.GetTcpSession()
                    time.sleep(1)
                #logging_util.debug('receiver.run step -5')
                try:
                    out = session.Read()
                except:
                    time.sleep(1)
                    continue
                #print 'receiver incomming pack', out.code
                if out.code == net.NET_TIME_SYNC :
                    in_ = DataInputX(out.data)
                    prevAgentTime = in_.readLong()
                    serverTime = in_.readLong()
                    now = dateutil.now()
                    turnaroundTime = now - prevAgentTime
                    if turnaroundTime < 500 and math.fabs(float(serverTime-now)) > 1000 :
                        dateutil.setServerDelta(dateutil.getServerDelta()+serverTime - now)
                    self.__timeSynced = True
                    continue

                if conf.CypherLevel > 0 :
                    #print 'receiver step -0.0.1', out.transferKey,secuSession.transferKey, out.code
                    if out.transferKey != secuSession.transferKey :
                        continue
                    #print 'receiver step -0.0.2'
                    secureMask =  net.GetSecureMask(out.code)
                    #print 'receiver step -0.0.3', out.code
                    if secureMask == net.NET_SECURE_HIDE:
                        #print 'receiver step -0.0.4'
                        if secuSession.cypher is not None:
                            out.data = secuSession.cypher.Hide(out.data)

                    elif secureMask == net.NET_SECURE_CYPHER:
                        #print 'receiver step -0.0.5'
                        if secuSession.cypher is not None:
                            out.data = secuSession.cypher.Decrypt(out.data)
                    else:
                        out.data = None
                #print 'receiver step -0.1'
                if out.data:
                    p = Pack.toPack(out.data)
                    #print 'receiver step -1'
                    self.__queue.put(p)

                time.sleep(0.001)
            except Exception, e:
                logging_util.logStack(e)
                time.sleep(0.001)

    def get(self):
        return self.__queue.get()

__receiver = __Receiver()
__receiver.start()

def getReceiver():
    global __receiver

    return __receiver