

NET_SECURE_HIDE   = 0x01
NET_SECURE_CYPHER = 0x02
NET_RESERVED1     = 0x04
NET_RESERVED2     = 0x08
NET_RESERVED3     = 0x10
NET_RESERVED4     = 0x20
NET_RESERVED5     = 0x40
NET_RESERVED6     = 0x80

NET_KEY_EXTENSION = 0xfd
NET_TIME_SYNC     = 0xfe
NET_KEY_RESET     = 0xff

NETSRC_AGENT_JAVA_EMBED   = 1
NETSRC_AGENT_JAVA_WATCHER = 2
NETSRC_SERVER_YARD        = 3
NETSRC_SERVER_PROXY       = 4

TCP_NONE = 0x00
TCP_OK   = 0x01

PARAM_KEEPALIVE = 1
PARAM_AGENT_BOOT_ENV = 2
PARAM_CONFIGURE_UPDATE = 3
PARAM_CONFIGURE_GET = 4
PARAM_COMPO_VERSIONS = 5
PARAM_THREAD_LIST = 7
PARAM_THREAD_DETAIL = 8
PARAM_GET_ACTIVE_STACK = 9
PARAM_HEAP_HISTO = 10
PARAM_LOADED_CLASS_LIST = 11
PARAM_GET_ENV = 12
PARAM_SYSTEM_GC = 13
PARAM_SET_CONFIG = 14
PARAM_OPEN_SOCKET_LIST = 15
PARAM_LOADED_CLASS_DETAIL = 16
PARAM_LOADED_CLASS_REDEFINE = 17
PARAM_GET_CONFIG = 200

PARAM_AGENT_JAR_LIST = 18
PARAM_AGENT_JAR_SAVE = 19
PARAM_AGENT_JAR_DELETE = 20

PARAM_RESET_STRING_SENT_MARK = 21

PARAM_AGENT_LOG_LIST = 22
PARAM_AGENT_LOG_READ = 23
PARAM_THREAD_CONTROL = 24

PARAM_GET_TOPOLOGY = 27

PARAM_NET_STAT = 28
PARAM_PS_EF = 29
PARAM_DOCKER_LIST = 30

PARAM_REMOTE_CMD= 33
PARAM_INFRA_HOSTINFO        = 49

# Script Manager
PARAM_SCRIPT_MANAGER_REQUEST    = 701
PARAM_SCRIPT_MANAGER_EXEC       = 702
PARAM_SCRIPT_MANAGER_STATUS     = 703
PARAM_SCRIPT_MANAGER_FILEREAD   = 704
PARAM_SCRIPT_MANAGER_FILESAVE   = 705
PARAM_SCRIPT_MANAGER_FILELIST   = 706
PARAM_SCRIPT_MANAGER_FILEDELETE = 707

def GetSecureMask(code) :
    if code < 0 :
        return 0

    return (code & NET_SECURE_HIDE) | (code & NET_SECURE_CYPHER)


import time
def startNet():
    import receiver
    import tcpsession
    while True:
        session = tcpsession.GetTcpSession()
        if session and session.isOpen() and receiver.getReceiver().isTimeSynced():
            break
        time.sleep(1)