from whatap.io.data_outputx import DataOutputX
from whatap.io.data_inputx import DataInputX
from whatap.util.keygen import KeyGen
from whatap.util.hexa32 import Hexa32

def Build(pcode , secure_key ):
	out = DataOutputX()
	out.writeDecimal(pcode)
	out.writeBlob(secure_key)
	sz = out.size()
	n = sz / 8
	if sz-n*8 > 0 :
		out.writeLong(KeyGen.next())
		n+=1

	in_ = DataInputX(out.toByteArray())
	sb = ""
	for i in range(n):
		if i > 0:
			sb += "-"
		sb += Hexa32.toString32(in_.readLong())

	return sb

def Parse(lic ):
    tokens = lic.split("-")
    out = DataOutputX()
    for token in tokens:
        out.writeLong(Hexa32.toLong32(token))

    in_ = DataInputX(out.toByteArray())
    pcode = in_.readDecimal()
    security_key = in_.readBlob()
    return pcode, security_key

