
from whatap.pack.smtcp_pack import SMTCPPortPerfPack, TCPPortPerf
import whatap.osinfo as osinfo
import whatap.agent.data.data_pack as data
import whatap.agent.conf.configure as config
from whatap.util.ip_util import IPUtil
class TaskTCP:
    def __init__(self):
        pass

    def interval(self):
        return 20

    def process(self, os_ , pcode , oid , now ) :
        def onPerf(perfs=[]):
            p = SMTCPPortPerfPack()
            p.pcode = pcode
            p.oid = oid
            p.time = now
            p.os = os_
            n = []
            for (ip, port, isAlive) in perfs:
                portPerf = TCPPortPerf()
                portPerf.ip = IPUtil.strToInt(ip)
                portPerf.port = port
                portPerf.isAlive = isAlive
                n.append(portPerf)
            p.tcpPortPerf = n
            data.SendHide(p)
        
        m = config.GetConfig().searchKey(config.TCPCheck)
        timeout = config.GetConfig().tcpcheck_timeout

        if m:
            checkurls= m.values()
            osinfo.TCPCheckSchedule(checkurls, timeout, onPerf)
            
        return None