import threading, time
import whatap.agent.secure.security_master as secure
import whatap.agent.data.data_text as data
import whatap.agent.data.data_pack as datapack
from whatap.pack.pack_enum import PackEnum
import whatap.pack.smproc_pack as smproc_pack
import whatap.osinfo as osinfo
from whatap.util.hash_util import HashUtil as hash
from whatap.util.date_util import DateUtil as dateutil
import whatap.agent.conf.configure as conf

class DEPRECATED_TaskProc(threading.Thread):
    def __init__(self):
        threading.Thread.__init__(self)
        self.__started = False

    def interval(self):
        #return 20
        return 5

    def process(self, os_ , pcode , oid , now ) :
        self.__os = os_
        self.__pcode = pcode
        self.__oid = oid
        if not self.__started:
            self.__started = True
            self.start()

        return None

    def run(self):
        proc = osinfo.GetProc()
        while True:
            procs, now = proc.getProcs()
            if not procs:
                time.sleep(0.5)
                continue

            p= smproc_pack.SMProcPack()
            p.pcode = self.__pcode
            p.oid = self.__oid
            p.time = dateutil.now()
            p.os = self.__os
            for procperf in procs:
                pf = smproc_pack.ProcPerf()
                pf.ppid = procperf.ppid
                pf.pid = procperf.pid
                pf.cpu = procperf.cpu
                pf.memoryBytes = procperf.memoryBytes
                pf.memoryPercent = procperf.memoryPercent
                pf.memoryShared = procperf.sharedMemory
                pf.readBps = procperf.readBps
                pf.writeBps = procperf.writeBps
                pf.cmd1 = hash.hash(procperf.cmd1)
                data.sendHashText(PackEnum.TEXT_SYS_PROC_CMD1, pf.cmd1, procperf.cmd1)
                pf.cmd2 = hash.hash(procperf.cmd2)
                data.sendHashText(PackEnum.TEXT_SYS_PROC_CMD2, pf.cmd2, procperf.cmd2)
                #print 'task_proc.cmd1:', pf.pid, procperf.cmd1, " ", pf.memoryPercent, pf.memoryBytes, procperf.cmd2
                pf.readIops = procperf.readIops
                pf.writeiops = procperf.writeIops
                pf.user = hash.hash(procperf.user)
                data.sendHashText(PackEnum.TEXT_SYS_PROC_USER, pf.user, procperf.user)
                pf.state = hash.hash(procperf.state)
                data.sendHashText(PackEnum.TEXT_SYS_PROC_STATE, pf.state, procperf.state)
                pf.createTime = procperf.createTime

                for n in procperf.net:
                    pnp = smproc_pack.ProcNetPerf()
                    pnp.ip = n.localip
                    pnp.port = n.localport
                    pnp.count = n.conn
                    pf.net.append(pnp)
                for f in procperf.file:
                    pfp = smproc_pack.ProcFilePerf()
                    pfp.filepath = hash.hash(f.name)
                    data.sendHashText(PackEnum.TEXT_SYS_PROC_FILENAME, pfp.filepath, f.name)
                    pfp.size = f.size
                    pf.file.append(pfp)

                p.proc.append(pf)

            datapack.SendHide(p)
            time.sleep(0.5)

class TaskProc(threading.Thread):
    def interval(self):
        return 20

    def process(self, os_ , pcode , oid , now ) :
        if not conf.GetConfig().serverProcessMonCheck:
            return
        
        procs = osinfo.GetProc()
        if not procs:
            return None
        p= smproc_pack.SMProcPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.os = os_
        for procperf in procs:
            pf = smproc_pack.ProcPerf()
            pf.ppid = procperf.ppid
            pf.pid = procperf.pid
            pf.cpu = procperf.cpu
            pf.memoryBytes = procperf.memoryBytes
            pf.memoryPercent = procperf.memoryPercent
            pf.memoryShared = procperf.sharedMemory
            pf.readBps = procperf.readBps
            pf.writeBps = procperf.writeBps
            pf.cmd1 = hash.hash(procperf.cmd1)
            data.sendHashText(PackEnum.TEXT_SYS_PROC_CMD1, pf.cmd1, procperf.cmd1)
            pf.cmd2 = hash.hash(procperf.cmd2)
            data.sendHashText(PackEnum.TEXT_SYS_PROC_CMD2, pf.cmd2, procperf.cmd2)
            #print 'task_proc.cmd1:', pf.pid, procperf.cmd1, " ", pf.memoryPercent, pf.memoryBytes, procperf.cmd2
            pf.readIops = procperf.readIops
            pf.writeiops = procperf.writeIops
            pf.user = hash.hash(procperf.user)
            data.sendHashText(PackEnum.TEXT_SYS_PROC_USER, pf.user, procperf.user)
            pf.state = hash.hash(procperf.state)
            data.sendHashText(PackEnum.TEXT_SYS_PROC_STATE, pf.state, procperf.state)
            pf.createTime = procperf.createTime

            for n in procperf.net:
                pnp = smproc_pack.ProcNetPerf()
                pnp.ip = n.localip
                pnp.port = n.localport
                pnp.count = n.conn
                pf.net.append(pnp)
            for f in procperf.file:
                pfp = smproc_pack.ProcFilePerf()
                pfp.filepath = hash.hash(f.name)
                data.sendHashText(PackEnum.TEXT_SYS_PROC_FILENAME, pfp.filepath, f.name)
                pfp.size = f.size
                pf.file.append(pfp)

            p.proc.append(pf)

        return p

