import threading, time
import whatap.agent.secure.security_master as secure
import whatap.agent.data.data_text as data
from whatap.pack.pack_enum import PackEnum
import whatap.pack.smnetperf_pack as smnetperf_pack
import whatap.osinfo as osinfo
from whatap.util.hash_util import HashUtil as hash

class TaskNet:
    def __init__(self):
        pass

    def interval(self):
        return 5

    def process(self, os_ , pcode , oid , now ) :
        netperfs = osinfo.GetNicUtil()
        if not netperfs:
            return None

        p= smnetperf_pack.SMNetPerfPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.os = os_
        for netperf in netperfs:
            n = smnetperf_pack.NetPerf()
            n.desc = hash.hash(netperf.desc)
            data.sendHashText(PackEnum.TEXT_SYS_NET_DESC, n.desc, netperf.desc)
            n.ip = netperf.ip
            n.hwAddr = netperf.hwAddr
            n.trafficIn = netperf.trafficIn
            n.trafficOut = netperf.trafficOut
            n.packetIn = netperf.packetIn
            n.packetOut = netperf.packetOut
            n.errorIn = netperf.errorIn
            n.errorOut =  netperf.errorOut
            n.droppedOut = netperf.droppedOut
            n.droppedIn = netperf.droppedIn
            p.netPerf.append(n)

        return p
