import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure
from whatap.util.hash_util import HashUtil as hashutil
from whatap.value.list_value import ListValue 

class TaskInfraZFSPerf:
    ZFS = "infra_zfs_perf"

    ZFS_NAME = "name"
    ZFS_TYPE = "deviceType"
    ZFS_TOTAL_BYTE = "total"
    ZFS_READ_BYTE = "read"
    ZFS_WRITE_BYTE = "write"
    ZFS_TOTAL_IOPS = "totalIops"
    ZFS_READ_IOPS = "readIops"
    ZFS_WRITE_IOPS = "writeIops"

    def __init__(self, interval = 5):
        self.init = osinfo.InitZfsInfo()
        self.intervalValue = interval
        self.recType = 2

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        if not self.init:
            return None

        zfsInfos = osinfo.GetZfsInfo()
        if not zfsInfos:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraZFSPerf.ZFS
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        idList = ListValue()
        nameList = ListValue()
        typeList = ListValue()
        totalList = ListValue()
        readList = ListValue()
        writeList = ListValue()
        totalIopsList = ListValue()
        readIopsList = ListValue()
        writeIopsList = ListValue()

        for zfsInfo in zfsInfos.values():
            key = hashutil.hashFromString("{}{}".format(zfsInfo.name, zfsInfo.zfsType))
            idList.addLong(key)
            nameList.addString(zfsInfo.name)
            typeList.addString(zfsInfo.zfsType)
            totalList.addFloat(float(zfsInfo.readBandwidth + zfsInfo.writeBandwidth))
            readList.addFloat(float(zfsInfo.readBandwidth))
            writeList.addFloat(float(zfsInfo.writeBandwidth))

            totalIopsList.addFloat(float(zfsInfo.readOperation+ zfsInfo.writeOperation))
            readIopsList.addFloat(float(zfsInfo.readOperation))
            writeIopsList.addFloat(float(zfsInfo.writeOperation))

        p.put("@id", idList)
        p.put(TaskInfraZFSPerf.ZFS_NAME, nameList)
        p.put(TaskInfraZFSPerf.ZFS_TYPE, typeList)
        p.put(TaskInfraZFSPerf.ZFS_TOTAL_BYTE, totalList)
        p.put(TaskInfraZFSPerf.ZFS_READ_BYTE, readList)
        p.put(TaskInfraZFSPerf.ZFS_WRITE_BYTE, writeList)
        p.put(TaskInfraZFSPerf.ZFS_TOTAL_IOPS, totalIopsList)
        p.put(TaskInfraZFSPerf.ZFS_READ_IOPS, readIopsList)
        p.put(TaskInfraZFSPerf.ZFS_WRITE_IOPS, writeIopsList)


        return p
