import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure
from whatap.util.hash_util import HashUtil as hashutil
from whatap.value.list_value import ListValue 

class TaskInfraDiskPerf:
    DISK = "infra_disk_perf"

    DISK_NAME = "name"
    DISK_BUSY = "busy"
    DISK_TOTAL_BPS = "total"
    DISK_READ_BPS = "read"
    DISK_WRITE_BPS = "write"
    DISK_TOTAL_IOPS = "totalIops"
    DISK_READ_IOPS = "readIops"
    DISK_WRITE_IOPS = "writeIops"
    DISK_READ_SERVICETIME = "readSvcTime"
    DISK_WRITE_SERVICETIME = "writeSvcTime"
    DISK_AVG_SERVICETIME = "avgSvcTime"
    DISK_AVG_WAITTIME = "avgWaitTime"

    def __init__(self, interval = 5):
        self.intervalValue = interval
        self.recType = 2

    def interval(self):
        return self.intervalValue


    def process(self, os_, pcode, oid, now):
        disk = osinfo.GetDiskIO()
        if not disk:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraDiskPerf.DISK
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        idList = ListValue()
        nameList = ListValue()
        busyList = ListValue()
        totalList = ListValue()
        readList = ListValue()
        writeList = ListValue()
        iopsList = ListValue()
        readIopsList = ListValue()
        writeIopsList = ListValue()
        readServiceTimeList = ListValue()
        writeServiceTimeList = ListValue()
        avgServiceTimeList = ListValue()
        avgWaitTimeList = ListValue()

        for d in disk:
            key = hashutil.hashFromString(d.deviceId)
            idList.addLong(key)
            nameList.addString(d.deviceId)
            busyList.addFloat(d.ioPercent)
            if d.totalBps == 0:
                totalList.addFloat(d.readBps + d.writeBps)
            else:
                totalList.addFloat(d.totalBps)
            readList.addFloat(d.readBps)
            writeList.addFloat(d.writeBps)
            if d.totalIops == 0:
                iopsList.addFloat(d.readIops + d.writeIops)
            else:
                iopsList.addFloat(d.totalIops)
            readIopsList.addFloat(d.readIops)
            writeIopsList.addFloat(d.writeIops)
            
            if d.readTime != osinfo._DiskPerf.UNSUPPORTED:
                readServiceTimeList.addFloat(d.readTime)
            if d.writeTime != osinfo._DiskPerf.UNSUPPORTED:
                writeServiceTimeList.addFloat(d.writeTime)
            if d.totalBusyTime != osinfo._DiskPerf.UNSUPPORTED:
                avgServiceTimeList.addFloat(d.totalBusyTime)
            if d.totalWaitTime != osinfo._DiskPerf.UNSUPPORTED:
                avgWaitTimeList.addFloat(d.totalWaitTime)
                


        p.put("@id", idList)
        p.put(TaskInfraDiskPerf.DISK_NAME, nameList)
        p.put(TaskInfraDiskPerf.DISK_BUSY, busyList)
        p.put(TaskInfraDiskPerf.DISK_TOTAL_BPS, totalList)
        p.put(TaskInfraDiskPerf.DISK_READ_BPS, readList)
        p.put(TaskInfraDiskPerf.DISK_WRITE_BPS, writeList)
        p.put(TaskInfraDiskPerf.DISK_TOTAL_IOPS, iopsList)
        p.put(TaskInfraDiskPerf.DISK_READ_IOPS, readIopsList)
        p.put(TaskInfraDiskPerf.DISK_WRITE_IOPS, writeIopsList)
        if readServiceTimeList.size() > 0:
            p.put(TaskInfraDiskPerf.DISK_READ_SERVICETIME, readServiceTimeList)
        if writeServiceTimeList.size() > 0:
            p.put(TaskInfraDiskPerf.DISK_WRITE_SERVICETIME, writeServiceTimeList)
        if avgServiceTimeList.size() > 0:
            p.put(TaskInfraDiskPerf.DISK_AVG_SERVICETIME, avgServiceTimeList)
        if avgWaitTimeList.size() > 0:
            p.put(TaskInfraDiskPerf.DISK_AVG_WAITTIME, avgWaitTimeList)


        return p

