import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure

class TaskInfraDisk:
    DISK = "infra_disk"
    DISK_READ_BPS= "read"
    DISK_WRITE_BPS= "write"
    DISK_TOTAL_BPS= "total"
    DISK_READ_IOPS = "readIops"
    DISK_WRITE_IOPS = "writeIops"
    DISK_TOTAL_IPOS = "totalIops"

    def __init__(self, interval = 2):
        self.intervalValue = interval
        self.recType = 1

    def interval(self):
        return self.intervalValue

    def process(self, os_, pcode, oid, now):
        disk = osinfo.GetTotalDisk()
        if not disk:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraDisk.DISK
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))


        p.put(TaskInfraDisk.DISK_READ_BPS, disk.readBps)
        p.put(TaskInfraDisk.DISK_WRITE_BPS, disk.writeBps)
        if disk.totalBps == 0:
            p.put(TaskInfraDisk.DISK_TOTAL_BPS, disk.readBps + disk.writeBps)
        else:
            p.put(TaskInfraDisk.DISK_TOTAL_BPS, disk.totalBps)
            

        p.put(TaskInfraDisk.DISK_READ_IOPS, disk.readIops)
        p.put(TaskInfraDisk.DISK_WRITE_IOPS, disk.writeIops)
        if disk.totalIops == 0:
            p.put(TaskInfraDisk.DISK_TOTAL_IPOS, disk.readIops + disk.writeIops)
        else:
            p.put(TaskInfraDisk.DISK_TOTAL_IPOS, disk.totalIops)


        return p

 
