import time
import whatap.pack.tagcount_pack as tagcount_pack 
import whatap.osinfo as osinfo
import whatap.agent.secure.security_master as secure
from whatap.util.hash_util import HashUtil as hashutil
from whatap.value.list_value import ListValue 

class TaskInfraCPUCore:
    CPUCORE = "infra_cpu_core"
    CPUCORE_COREID = "coreid"
    CPUCORE_USER = "user"
    CPUCORE_SYS = "sys"
    CPUCORE_NICE = "nice"
    CPUCORE_TOTAL = "total"
    CPUCORE_WAIT = "wait"
    CPUCORE_TOTAL_WAIT = "total_wait"
    CPUCORE_IDLE = "idle"

    def __init__(self, interval = 5):
        self.intervalValue = interval
        self.recType = 2

    def interval(self):
        return self.intervalValue


    def process(self, os_, pcode, oid, now):
        coreperfs = osinfo.GetCpuCore()
        if not coreperfs:
            return None

        secu = secure.GetSecurityMaster()
        p = tagcount_pack.TagCountPack()
        p.pcode = pcode
        p.oid = oid
        p.time = now
        p.category = TaskInfraCPUCore.CPUCORE
        p.putTag("oname", str(secu.oname))
        p.putTag("!rectype", str(self.recType))

        idList = ListValue()
        coreIdList = ListValue()
        userList = ListValue()
        sysList = ListValue()
        niceList = ListValue()
        totalList = ListValue()
        waitList = ListValue()
        totalWaitList = ListValue()
        idleList = ListValue()

        #hpux
        if isinstance(coreperfs, dict):
            for i, coreperf in coreperfs.items():
                key = hashutil.hashFromString("{}".format(i))
                idList.addLong(key)
                coreIdList.addLong(i)
                userList.addFloat(coreperf.user)
                sysList.addFloat(coreperf.system)
                niceList.addFloat(coreperf.nice)
                total = coreperf.user + coreperf.system + coreperf.nice
                totalList.addFloat(total)
                waitList.addFloat(coreperf.iowait)
                totalWaitList.addFloat(total + coreperf.iowait)
                idleList.addFloat(coreperf.idle)
        elif isinstance(coreperfs, list):
            for i, coreperf in enumerate(coreperfs):
                key = hashutil.hashFromString("{}".format(i))
                idList.addLong(key)
                coreIdList.addLong(i)
                userList.addFloat(coreperf.user)
                sysList.addFloat(coreperf.system)
                total = coreperf.user + coreperf.system + coreperf.nice
                totalList.addFloat(total)
                waitList.addFloat(coreperf.iowait)
                totalWaitList.addFloat(total + coreperf.iowait)
                idleList.addFloat(coreperf.idle)

        p.put("@id", idList)
        p.put(TaskInfraCPUCore.CPUCORE_COREID, coreIdList)
        p.put(TaskInfraCPUCore.CPUCORE_USER, userList)
        p.put(TaskInfraCPUCore.CPUCORE_SYS, sysList)
        p.put(TaskInfraCPUCore.CPUCORE_NICE, niceList)
        p.put(TaskInfraCPUCore.CPUCORE_TOTAL, totalList)
        p.put(TaskInfraCPUCore.CPUCORE_WAIT, waitList)
        p.put(TaskInfraCPUCore.CPUCORE_TOTAL_WAIT, totalWaitList)
        p.put(TaskInfraCPUCore.CPUCORE_IDLE, idleList)

        return p


