import whatap.agent.conf.configure as config
from whatap.pack.tagcount_pack import TagCountPack
from datetime import datetime
import glob, os.path
import whatap.agent.data.data_pack as data

class TaskFileSystem:
    def __init__(self):
	    pass

    def interval(self):
        return config.GetConfig().FileCountInterval

    def process(self, os_ , pcode , oid , now ) :
        filepatterns = config.GetConfig().searchKey(config.FileCount)
        t = datetime.now()
        for filepattern in filepatterns.values():
            evaluatedPath = t.strftime(filepattern)
            p = TagCountPack(category='agent_file_count')
            p.pcode = pcode
            p.oid = oid
            p.time = now
            p.tags.putString("filepattern", evaluatedPath)
            matches = glob.glob(evaluatedPath)
            filecount =0
            for evaluatedPath in matches:
                if not os.path.isdir(evaluatedPath):
                    filecount +=1
            p.fields.putLong('count', filecount)
            data.SendHide(p)

        return None
