import whatap.util.panic_util as panic_util
import whatap.agent.secure.security_master as secure
from whatap.pack.tagcount_pack import TagCountPack
from whatap.util.date_util import DateUtil as dateutil
import whatap.agent.data.data_pack as data
import time



def sendPendingTagCount():
    tagCounts = panic_util.GetTagCount()
    if not tagCounts:
        return

    for tagCountArg in tagCounts:
        secu = secure.GetSecurityMaster()
        p = TagCountPack(category=tagCountArg.category)
        p.pcode = secu.pcode
        p.oid = secu.oid
        p.time = dateutil.now()

        for k, v in tagCountArg.tags.items():
            p.tags.putString(k, v)

        for k, v in tagCountArg.fields.items():
            p.tags.putString(k, v)

        data.SendSecure(p)


def startHouseKeeping():
    while True:
        sendPendingTagCount()
        time.sleep(1)
