import whatap.net as net
import whatap.agent.counter.counter_manager as counter
import whatap.agent.control.control_handler as control_handler
import whatap.agent.counter.houseKeepingHelper as houseKeepingHelper
import whatap.downcheck as downcheck
import whatap.agentless.checkmain as agentless
import whatap.agent.conf.configure as config
import whatap.agent.cron.cronjob as cronjob
import whatap.agent.cron.script_manager as script_manager
from datetime import datetime, timedelta
import whatap.util.logging_util as logging_util
import whatap.util.thread_util as thread_util
import whatap.util.panic_util as panic_util
import whatap.agent.secure.security_master as secure
import whatap.net.tcpsession as tcpsession
import whatap.osinfo as osinfo

module_loaded = datetime.now()


def boot():
    net.startNet()
    counter.startCounterManager()
    startExtension()
    control_handler.initControlHandler()
    downcheck.startHello()

    agentless.start()
    osinfo.InitSyslogRedirect()
    script_manager.init_script_manager()
    cronjob.start_cronjob()

    thread_util.async(houseKeepingHelper.startHouseKeeping)

def startExtension():
    import whatap.ext as _

def isOK():
    ret = True
    if datetime.now() - module_loaded > timedelta(minutes= config.GetConfig().HealthCheckCoolTime ):
        logging_util.debug("AgentBoot.IsOK step -0")
        secu = secure.GetSecurityMaster()
        logging_util.debug("AgentBoot.IsOK step -1")
        ret = secu.pcode != 0
        if not ret:
            message = "AgentBoot.IsOK pcode check {}".format(ret)
            logging_util.error(message)
            panic_util.AgentEventAsync({"event":"Error"}, {"log":message})
        ret = ret and (secu.oid != 0)
        if not ret:
            message = "AgentBoot.IsOK oid check {}".format(ret)
            logging_util.error(message)
            panic_util.AgentEventAsync({"event":"Error"}, {"log":message})
        ret = ret and tcpsession.isSessionOK()
        if not ret:
            message = "AgentBoot.IsOK session check {}".format(ret)
            logging_util.error(message)
            panic_util.AgentEventAsync({"event":"Error"}, {"log":message})
        ret = ret and counter.isOK()
        if not ret:
            message = "AgentBoot.IsOK counter check {}".format(ret)
            logging_util.error(message)
            panic_util.AgentEventAsync({"event":"Error"}, {"log":message})
    return ret

def end():
    pass
