import math
import time
import simpleplugin
import simpleplugin.inputs as inputs

name = "sinecosine"


class SineCosine(simpleplugin.Input):
    def __init__(self):
        self.Magnitude = 0.0
        self.Inc = 0.1
        self.x = 0.0
        self.interval = 1000

    def load(self, parsedDict):
        self.Magnitude = parsedDict.get('Magnitude', self.Magnitude)
        self.Inc = parsedDict.get('Inc', self.Inc)
        self.x = 0.0
        self.interval = 1000


    def name(self):
        return name

    def interval(self):
        return self.interval

    def gather(self, acc):
        fields = {}
        tags = {}

        tags["Magnitude"] = str(self.Magnitude)
        tags["Inc"] = str(self.Inc)
        fields["X"] = self.x
        fields["sine"] = self.Magnitude * math.sin(self.x)
        fields["cosine"] = math.cos(self.x)

        acc.addFields("sinecosine", fields, tags)

        self.x += self.Inc

        return None


inputs.add(name, lambda: SineCosine())
