import os
import time

def isFileNew(timestamp, file_path):
    stat_info = os.stat(file_path)

    ctime = time.localtime(stat_info.st_ctime)

    ctime_millis = int(time.mktime(ctime) * 1000)
    return timestamp > 0 and timestamp < ctime_millis

def getFileSize(file_path):
    try:
        stat_info = os.stat(file_path)
        modified_time = int(stat_info.st_mtime * 1000)
        file_size = stat_info.st_size
        return modified_time, file_size, None
    except OSError as e:
        return None, None, e
