import os
import sys
from Queue import Queue
import simpleplugin.agent as agent

def initLogging():
    import logging
    import sys

    root = logging.getLogger()
    root.setLevel(logging.DEBUG)

    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    handler.setFormatter(formatter)
    root.addHandler(handler)

def main():
    print("simple agent plugin")

    # Assuming the pluginPrefix is passed as a command-line argument
    if len(sys.argv) < 2:
        print("Usage: python script.py <plugin_prefix>")
        sys.exit(1)

    plugin_prefix = sys.argv[1]

    # Creating a Queue for inter-process communication
    src = Queue(maxsize=1000)

    # Mocking the behavior of Go agent in Python
    go_agent = agent.Agent.newAgent(plugin_prefix)
    go_agent.startEx(src)

    
    # Consuming metrics from the Queue
    while True:
        metric = src.get()
        print(metric)


import sys, signal
def signal_handler(signal, frame):
    print("Received SIGINT. Exiting...")
    sys.exit(0)

# Set the signal handler
signal.signal(signal.SIGINT, signal_handler)

if __name__ == "__main__":
    initLogging()
    main()
