class PacketEnum {
    static get PACKET_BUFFER_SIZE() { return 48 * 1024; }
    static get PACKET_SEND_BUFFER_SIZE() { return 64 * 1024; }
    static get DATA_SIZE_LIMIT() { return 30 * 1024 + 1; }

    static get SERVER() { return "127.0.0.1"; }
    static get PORT() { return 6600; }
    static get PACKET_VERSION() { return 60101; }

    // PACKET_HEADER
    static get PACKET_HEADER_TYPE_POS() { return 0; }
    static get PACKET_HEADER_TYPE_SIZE() { return 1; }

    static get PACKET_HEADER_VERSION_POS() { return 1; }
    static get PACKET_HEADER_VERSION_SIZE() { return 4; }

    static get PACKET_HEADER_LEN_POS() { return 5; }
    static get PACKET_HEADER_LEN_SIZE() { return 4; }

    // PACKET_BODY
    static get PACKET_BODY_ID_POS() { return 9; }
    static get PACKET_BODY_ID_SIZE() { return 8; }

    static get PACKET_BODY_START_TIME_POS() { return 17; }
    static get PACKET_BODY_START_TIME_SIZE() { return 8; }

    static get PACKET_BODY_ELAPSED_POS() { return 25; }
    static get PACKET_BODY_ELAPSED_SIZE() { return 4; }

    static get PACKET_BODY_CPU_POS() { return 29; }
    static get PACKET_BODY_CPU_SIZE() { return 8; }

    static get PACKET_BODY_MEMORY_POS() { return 37; }
    static get PACKET_BODY_MEMORY_SIZE() { return 8; }

    static get PACKET_BODY_THREAD_ID_POS() { return 45; }
    static get PACKET_BODY_THREAD_ID_SIZE() { return 8; }

    static get PACKET_BODY_TRACE_DATA_POS() { return 53; }

    // PACKET_SIZE
    static get PACKET_HEADER_SIZE() {
        return this.PACKET_HEADER_TYPE_SIZE + this.PACKET_HEADER_VERSION_SIZE + this.PACKET_HEADER_LEN_SIZE;
    }

    static get PACKET_BODY_REQUIRED_SIZE() {
        return this.PACKET_BODY_ID_SIZE + this.PACKET_BODY_START_TIME_SIZE + this.PACKET_BODY_ELAPSED_SIZE +
            this.PACKET_BODY_CPU_SIZE + this.PACKET_BODY_MEMORY_SIZE;
    }
}

module.exports = PacketEnum;