const conf = require('../conf/configure'),
    AsyncSender = require('../udp/async_sender'),
    PacketTypeEnum = require('../udp/packet_type_enum');

var TraceSql = function () {}

TraceSql.prototype.isSlowSQL = function (ctx) {
    if (!ctx) return;

    var profile_error_sql_time_max = conf.getProperty('profile_error_sql_time_max', 30000);
    var sql_elapsed = ctx.elapsed || 0;

    if (sql_elapsed > profile_error_sql_time_max) {
        if (!ctx.error) ctx.error = 1;
        ctx.status = 500;

        var errors = ['SLOW_SQL', 'SLOW SQL'];
        AsyncSender.send_packet(PacketTypeEnum.TX_ERROR, ctx, errors);
    }
    return;
}

TraceSql.prototype.isTooManyRecords = function (rs_count, ctx) {
    if (!ctx) return;

    var profile_error_sql_fetch_max = conf.getProperty('profile_error_sql_fetch_max', 10000);
    if (rs_count && rs_count > profile_error_sql_fetch_max) {
        // Too many records 에러 처리
        if (!ctx.error) ctx.error = 1;
        ctx.status = 500;

        var errors = ['TOO_MANY_RECORDS', 'Too many records'];
        AsyncSender.send_packet(PacketTypeEnum.TX_ERROR, ctx, errors);
    }
}

module.exports = new TraceSql();