/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum');

function NullValue(){

    this.value = null;
    this.compareTo = function(obj) {
        if(obj instanceof NullValue) {
            return 0;
        }
        return 1;
    };
    this.equals = function(obj) {
        return obj instanceof NullValue;
    };
    this.hashCode = function() {
        return 0;
    };

}

NullValue.prototype = new Value();
NullValue.prototype.constructor = NullValue;
NullValue.prototype.getValueType = function () {
    return ValueEnum.NULL;
};
NullValue.prototype.write = function(dout) {

};
NullValue.prototype.read = function(din) {
    return this;
};
NullValue.prototype.toObject = function() {
    return null;
};

module.exports = NullValue;