/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap   = require('./linkedmap');

function IntIntMap(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
}

IntIntMap.prototype = new LinkedMap();
IntIntMap.prototype.constructor = IntIntMap;

IntIntMap.prototype.none = function () {
    return 0;
};
IntIntMap.prototype.hash = function (key /*int*/) {
    return Math.abs(key);
};
IntIntMap.prototype.equals = function (key1, key2) {
    return key1===key2;
};
IntIntMap.prototype.sum = function (value1, value2) {
    return value1+value2;
};

IntIntMap.prototype.toBytes = function (dout) {
    dout.writeDecimal(this.size());
    var en = this.entries();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        dout.writeDecimal(e.getKey());
        dout.writeDecimal(e.getValue());
    }
};
IntIntMap.prototype.toObject = function (din) {
    var cnt = din.readDecNumber();
    for (var i = 0; i < cnt; i++) {
        var key = din.readDecNumber();
        var value = din.readDecNumber();
        this.put(key, value);
    }
    return this;
};

module.exports = IntIntMap;