
# 🚀 WhaTap Node.js Agent

> **Comprehensive Node.js Application Performance Monitoring (APM) Solution**

WhaTap Node.js Agent provides real-time monitoring, tracing, and performance analysis capabilities as a professional APM agent.

## 📋 Supported Environment
- **Platform**: macOS (64bit), Linux (64bit)
- **Node.js Version**: 17.0.0 or higher
- **Database**: MySQL, PostgreSQL, MSSQL, Oracle, MariaDB, MongoDB, Redis
- **Framework**: Express, Fastify, Socket.IO, WebSocket, GraphQL

You can install WhaTap using npm with the following command:

```bash
$ npm install whatap
```



## 📝 Configuration

Copy the `whatap.conf` file from `node_modules/whatap` to your project root directory and configure it as follows:

```ini
# Essential Settings
license=XXXXXXXXXXXXXX-XXXXXXXXXXXXXX-XXXXXXXXXXXXXX
whatap.server.host=XXX.XXX.XXX.XXX

# Application Identification Settings
app_name=MyNodeApp              # Application name
app_process_name=node           # Process name
```



## 🚀 Usage

### Agent Initialization

To activate WhaTap monitoring in your Node.js application, add the WhaTap agent initialization code to your application's **top-level entry point file**.

> **⚠️ Important**: The WhaTap agent must be loaded before all other modules.

### Method 1: Using require('whatap') in Code

```javascript
// app.js (or server.js)
var WhatapAgent = require('whatap').NodeAgent;

// Import other modules after
const express = require('express');
const app = express();

// Application logic...
```

Run with:
```bash
node app.js
```

### Method 2: Using -r flag (without code modification)

If you prefer not to modify your application code, you can use the `-r` flag:

```bash
node -r whatap app.js
```

### ECMAScript Module (ESM) System

```javascript
// app.js (or server.js)
import WhatapAgent from 'whatap';
WhatapAgent.NodeAgent;

// Import other modules after
import express from 'express';
const app = express();

// Application logic...
```

## ✅ Run Application

Once the agent configuration is complete, restart your application to begin monitoring:

```bash
# Direct Node.js execution
node app.js

# Using npm scripts
npm start
```

### Monitoring Dashboard

Once your application is running, you can view the following information in the WhaTap console:

- 🔍 **Real-time Transactions**: HTTP requests, database query tracking
- 📊 **Performance Metrics**: CPU, memory, GC information
- 🚨 **Error Monitoring**: Application error and exception tracking
- 📈 **Statistical Analysis**: Response time and throughput statistics

