/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var NumberValue = require('./number-value'),
    ValueEnum   = require('./valueenum');

function DoubleValue(value) {
    NumberValue.call(this);
    this.value = value || 0.0;
    this.compareTo = function(object) {
        if(object instanceof DoubleValue) {
            if(this.value != object.value) {
                return this.value > object.value ? 1 : -1;
            } else {
                return 0;
            }
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof DoubleValue) {
            return this.value === object.value;
        }
        return false;
    };
}
DoubleValue.prototype = new NumberValue();
DoubleValue.prototype.constructor = DoubleValue;
DoubleValue.prototype.getValueType = function() {
    return ValueEnum.DOUBLE;
};
DoubleValue.prototype.doubleValue = function() {
    return this.value;
};
DoubleValue.prototype.floatValue = function() {
    return this.value;
};
DoubleValue.prototype.intValue = function() {
    return this.value.toFixed(0);
};
DoubleValue.prototype.longValue = function() {
    return Long.fromNumber(this.value);
};
DoubleValue.prototype.numberValue = function() {
    return this.value;
};

module.exports = DoubleValue;