var CompareUtil = {
    compareTo: function (l, r) {
        if (Array.isArray(l) && Array.isArray(r)) {
            return this.compareArrays(l, r);
        }
        if (typeof l === 'string' && typeof r === 'string') {
            return l.localeCompare(r);
        }
        if (typeof l === 'number' && typeof r === 'number') {
            return l === r ? 0 : l > r ? 1 : -1;
        }
        if (l && typeof l.compareTo === 'function' && r && typeof r.compareTo === 'function') {
            return l.compareTo(r);
        }
        throw new Error('Unsupported comparison types');
    },

    compareArrays: function (l, r) {
        if (l == null && r == null) return 0;
        if (l == null) return -1;
        if (r == null) return 1;
        for (let i = 0; i < l.length && i < r.length; i++) {
            let comp = this.compareTo(l[i], r[i]);
            if (comp !== 0) return comp;
        }
        return l.length - r.length;
    },

    equals: function (l, r) {
        return this.compareTo(l, r) === 0;
    },

    compareByteArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareShortArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareIntArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareFloatArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareLongArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareDoubleArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareStringArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareComparableArrays: function (l, r) {
        return this.compareArrays(l, r);
    },

    compareToValues: function (l, r) {
        if (l == null && r == null) return 0;
        if (l == null) return -1;
        if (r == null) return 1;
        return l.compareTo(r);
    },

    equalsByteArrays: function (l, r) {
        return this.compareByteArrays(l, r) === 0;
    },

    equalsShortArrays: function (l, r) {
        return this.compareShortArrays(l, r) === 0;
    },

    equalsIntArrays: function (l, r) {
        return this.compareIntArrays(l, r) === 0;
    },

    equalsFloatArrays: function (l, r) {
        return this.compareFloatArrays(l, r) === 0;
    },

    equalsLongArrays: function (l, r) {
        return this.compareLongArrays(l, r) === 0;
    },

    equalsDoubleArrays: function (l, r) {
        return this.compareDoubleArrays(l, r) === 0;
    },

    equalsStringArrays: function (l, r) {
        return this.compareStringArrays(l, r) === 0;
    },

    equalsComparableArrays: function (l, r) {
        return this.compareComparableArrays(l, r) === 0;
    },

    equalsValues: function (l, r) {
        return this.compareToValues(l, r) === 0;
    },

    equalsString: function (l, r) {
        if (l == null) return r == null;
        else return l === r;
    },

    equalsObject: function (l, r) {
        if (l == null) return r == null;
        else return l === r;
    },

    equalsLong: function (l, r) {
        return l === r;
    },

    equalsInt: function (l, r) {
        return l === r;
    },

    equalsFloat: function (l, r) {
        return l === r;
    }
};

module.exports = CompareUtil;
