/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DataInputX  = require('./../io/data-inputx'),
    License     = require('./../conf/license'),
    Cypher      = require('./../util/cypher'),
    IPUtil      = require('./../util/iputil'),
    OidUtil     = require('./../util/oidutil'),
    HashUtil    = require('./../util/hashutil');

var cluster = require('cluster');

var lastOid = 0;

var SecurityMaster = {
    ONAME: '',
    IP: 0,
    PCODE: 0,
    OKIND : 0,
    OKIND_NAME : null,
    ONODE : 0,
    ONODE_NAME : null,
    OID: 0 ,
    decideAgentOnameOid: function() {
        var conf = require('./../conf/configure');
        const myIp = IPUtil.getIp();
        conf.setProperty('whatap.ip', myIp);

        this.IP = IPUtil.stringToInt(myIp);
        var port = conf.getProperty("whatap.port");
        OidUtil.setIp(IPUtil.intToString(this.IP));
        OidUtil.setPort(port);
        OidUtil.setPid(process.pid);
        OidUtil.setHostName(require('os').hostname());
        OidUtil.setType(process.env.name || conf.getProperty("whatap.type", "NODE"));

        this.OID = conf.getProperty("OID", 0);
        this.ONAME = conf.getProperty("app_name", "");

        this.OKIND_NAME = conf.getProperty("whatap.okind", "")
        if(!this.OKIND_NAME){
            this.OKIND_NAME = process.env.WHATAP_OKIND || "";
        }
        if(!this.OKIND_NAME){
            this.OKIND_NAME = process.env.POD_NAME || ""
        }
        if(this.OKIND_NAME){
            this.OKIND = HashUtil.hashFromString(this.OKIND_NAME);
        }

        this.ONODE_NAME = conf.getProperty("whatap.onode", "");
        if(!this.ONODE_NAME){
            this.ONODE_NAME = process.env.NODE_NAME || "";
        }
        if(this.ONODE_NAME){
            this.ONODE = HashUtil.hashFromString(this.ONODE_NAME);
        }


        if (lastOid != this.OID) {
            lastOid = this.OID;
            require('../logger').print('WHATAP-401', "OID: " + this.OID + " ONAME: " + this.ONAME + " IP: " + IPUtil.intToString(this.IP), false);
        }
    }
};

module.exports = SecurityMaster;